(function (BEM, undefined){
    'use strict';

    BEM.DOM.decl('b-fieldgroup', {
        onSetMod: {
            js: function () {
                this._addListeners();
            }
        },

        /**
         * @public
         * @param {object} [values]
         * @return {(object|undefined)}
         **/
        val: function (values) {
            var fieldName = this.params.fieldName;
            var labelName = this.params.labelName;
            var value;
            var checked = this._isChecked();
            if (typeof values === 'undefined') {
                if (!this.hasMod('disabled', 'yes') && checked) {
                    values = {};
                    values[fieldName] = this._getField().val();
                    values[labelName] = this._getTriggerValue();
                }
                return values;
            } else {
                // label
                value = values[labelName];
                if (typeof value !== 'undefined') {
                    if (value.toString() === this._getTriggerValue() || value === true) {
                        this.setMod('checked', 'yes');
                        checked = true;
                    } else {
                        this.delMod('checked');
                        checked = false;
                    }
                }
                // field
                value = values[fieldName];
                if (checked && typeof value !== 'undefined') {
                    this._getField().val(value);
                }
            }
        },

        /**
         * @public
         * @return {string}
         **/
        getFieldName: function () {
            return this.params.fieldName;
        },

        /**
         * @protected
         * @return {string}
         **/
        _getTriggerValue: function () {
            return this._getTrigger.val();
        },

        /**
         * @protected
         **/
        _addListeners: function () {
            var trigger = this._getTrigger(); // jQuery | bem-block
            var field = this._getField();

            if (field && trigger) {
                trigger.on('change', this._onTriggerChange.bind(this));
            }
        },

        /**
         * @private
         **/
        _onTriggerChange: function () {
            var field = this._getField();

            if (typeof field === 'undefined' || field === null) {
                return;
            }

            if (this._isChecked() === true) {
                this.setMod('checked', 'yes');
            } else {
                this.delMod('checked');
            }
        },

        /**
         * @protected
         * @return {boolean}
         **/
        _isChecked: function () {
            return false;
        },

        /**
         * @protected
         * @return {object|null}
         **/
        _getField: function () {
            // по умолчанию туда можно положить что угодно
            return null;
        },

        /**
         * @protected
         * @return {object|null}
         **/
        _getTrigger: function () {
            // и тут, вроде, тоже много чего может быть
            return null;
        }
    });
})(BEM);
