/*jslint bitwise: true, plusplus: true, nomen:true*/
/*globals window, jQuery, BEM*/

(function(BEM, $, undefined) {

    'use strict';

    BEM.DOM.decl('b-fieldset', {
        onSetMod: {
            js: function() {
                this.__base();

                var blockFilters = [
                        'b-form-input',
                        'b-form-select',
                        'b-form-radio',
                        'b-form-checkbox',
                        'b-form-address',
                        'b-form-nr-address',
                        'b-form-clid-settings',
                        'b-form-attach',
                        'b-form-colorpicker',
                        'pi-form-checkbox',
                        'pi-form-colorpicker',
                        'pi-form-select'
                    ];

                bindToBlocks(this, blockFilters, 'change', $.proxy(debounce(triggerChange, 100), this));
            }
        },

        val: function () {
            return $(':input', this.domElem).serializeArray();
        }
    });

    function findBlocksInside(ctx, filter) {
        return ctx.findBlocksInside(filter);
    }

    function flatten(result, arr) {
        return result.concat(arr);
    }

    function bind(event, handler, block) {
        block.on(event, handler);
    }

    function bindToBlocks(ctx, filters, event, handler) {
        var findBlocksInsideCtx = $.proxy(findBlocksInside, null, ctx),
            bindEvent = $.proxy(bind, null, event, handler);

        filters.map(findBlocksInsideCtx)
            .reduce(flatten, [])
            .forEach(bindEvent);
    }

    function debounce(fn, timeout) {
        var timer, args;

        return function() {
            var _this = this;

            args = arguments;

            if (!timer) {
                timer = window.setTimeout(function() {
                    fn.apply(_this, args);
                    timer = null;
                }, timeout);
            }
        };
    }

    function triggerChange() {
        /*jshint validthis:true */
        this.trigger('change');
    }

})(BEM, jQuery);
