(function() {

var operations = {
    '>': {
        name: 'Больше',
        type: 'number'
    },
    '<': {
        name: 'Меньше',
        type: 'number'
    },
    '=': {
        name: 'Равно',
        type: 'number'
    },
    'LIKE': {
        name: 'Содержит',
        type: 'text'
    },
    'NOTLIKE': {
        name: 'Не содержит',
        type: 'text'
    },
    'IN': {
        name: '',
        type: 'enum'
    }
};

BEM.DOM.decl('b-filter-condition', {
    onSetMod: {
        js: function() {
            this.filter = this.findBlockOutside('b-filter');
            this.rows = [];

            if ( this.params.autoInit !== false ) {
                //this.afterCurrentEvent(this.initControls, this);
                this.initControls();
            }
        }
    },

    initControls: function(parent) {
        this.parent = parent;
        var fields = this.fields = this.params.fields || this.filter.getFieldsList();

        this.not = this.findBlockOn(this.elem('not'), 'b-form-select');
        this.plus = this.findBlockOn(this.elem('plus'), 'b-form-button');
        this.minus = this.findBlockOn(this.elem('minus'), 'b-form-button');

        //this.not.on('change', this.onNotChange, this);
        if ( this.hasMod('type', 'root') ) {
            this.plus.destruct();
            this.minus.destruct();
        }
        else {
            this.plus.on('click', this.onAddClick, this);
            this.minus.on('click', this.onRemoveClick, this);
        }

        if ( !this.rows.length ) {
            this.addRow();
        }
    },

    fieldBuilder: {
        'simple': function(name, field, row) {
            var editor = [
                    this.makeSelect(this.makeSelectOptions(operations, function(k, v) {
                        if ( v.type == field.type ) {
                            return [k, v.name];
                        }
                    }), 'ops'),
                    this.makeInput('value'),
                    {
                        block: 'b-form-button',
                        mods: { theme: 'grey-s', size: 's' },
                        mix: [{ block: 'b-filter-condition', elem: 'row-plus' }],
                        content: '+'
                    },
                    {
                        block: 'b-form-button',
                        mods: { theme: 'grey-s', size: 's' },
                        mix: [{ block: 'b-filter-condition', elem: 'row-minus' }],
                        content: '-'
                    }
                ],
                content = BEMHTML.apply(editor);
            var res = $(content);
            BEM.DOM.update(row.editor, res);

            var pl = row.plus = this.findBlockOn(this.findElem(res, 'row-plus'), 'b-form-button');
            pl.on('click', function() {
                this.addRow(row);
            }, this);

            var min = row.minus = this.findBlockOn(this.findElem(res, 'row-minus'), 'b-form-button');
            min.on('click', function() {
                this.removeRow(row);
            }, this);

            var ops = row.ops = this.findBlockOn(this.findElem(res, 'ops'), 'b-form-select');
            ops.on('change', function() {
                row.operation = this.val();
            });

            var value = row.input = this.findBlockOn(this.findElem(res, 'value'), 'b-form-input');
            row.getValue = function() { return value.val() };

            this.setMod(row.editor, 'type', 'simple');
        },
        'subfilter': function(name, field, row) {
            var editor = [
                    {
                        block: 'b-filter-condition',
                        mods: { 'type': 'subfilter' },
                        js: {
                            fields: field.subfields,
                            autoInit: false
                        }
                    }
                ],
                content = BEMHTML.apply(editor);
            var $content = $(content);
            var block = this.findBlockInside($content, 'b-filter-condition');
            BEM.DOM.update(row.editor, $content);
            block.initControls(this);
            block.on('remove', function() {
                this.removeRow(row);
            }, this);
            row.block = block;
            row.plus = block.elem('plus');
            row.minus = block.elem('minus');

            row.operation = '=';
            row.getValue = function() { return block.getConfig(); }

            this.setMod(row.editor, 'type', 'subfilter');
            this.checkAlone();
        },
        'multistate': function(name, field, row) {
            var editor = [
                    this.makeSelect(this.makeSelectOptions(field.values, function(k, v) { return [k, v.toString()]; }), 'values'),
                    {
                        block: 'b-form-button',
                        mods: { theme: 'grey-s', size: 's' },
                        mix: [{ block: 'b-filter-condition', elem: 'row-plus' }],
                        content: '+'
                    },
                    {
                        block: 'b-form-button',
                        mods: { theme: 'grey-s', size: 's' },
                        mix: [{ block: 'b-filter-condition', elem: 'row-minus' }],
                        content: '-'
                    }
                ],
                content = $(BEMHTML.apply(editor));
            BEM.DOM.update(row.editor, content);

            var pl = this.findBlockOn(this.findElem(content, 'row-plus'), 'b-form-button');
            pl.on('click', function() {
                this.addRow();
            }, this);

            var min = this.findBlockOn(this.findElem(content, 'row-minus'), 'b-form-button');
            min.on('click', function() {
                this.removeRow(row);
            }, this);

            row.operation = '=';

            var values = this.findBlockOn(this.findElem(content, 'values'), 'b-form-select');
            row.getValue = function() { return values.val(); };

            this.setMod(row.editor, 'type', 'simple');
        }
    },

    getBuilder: function(type) {
        if ( type == 'subfilter' || type == 'multistate' ) {
            return this.fieldBuilder[type];
        }
        return this.fieldBuilder['simple'];
    },

    onFieldChange: function(e) {
        var row = e.data,
            val = row.fieldBox.val(),
            f = this.fields[val],
            b = null;

        if ( b = this.getBuilder(f.type) ) {
            b.call(this, val, f, row);
        }

        row.field = {
            type: f.type,
            name: val
        };

        this.checkAlone();
    },

    onAddClick: function() {
        this.parent.addRow();
    },

    onRemoveClick: function() {
        this.trigger('remove');
        this.destruct();
    },

    makeSelectOptions: function(val, it, ctx) {
        var ops = [];

        $.each(val, function(k) {
            var args = it.call(ctx || {}, k, this);
            if ( args ) {
                ops.push({
                    elem: 'option',
                    item: 'option',
                    attrs: { value: args[0] },
                    value: args[0],
                    content: args[1]
                });
            }
        });

        return ops;
    },

    makeSelect: function(options, elem) {
        var select = {
            block: 'b-form-select',
            mods: { size: 's', theme: 'grey', layout: 'fixed' },
            content: [
                {
                    block: 'b-form-button',
                    type: 'button',
                    mods: { size: 's', theme: 'grey-s', valign: 'middle' },
                    content: ''
                },
                {
                    elem: 'select',
                    content: options
                }
            ]
        };

        if ( elem ) {
            select.mix = [{ block: 'b-filter-condition', elem: elem }];
        }

        return select;
    },

    makeInput: function(elem) {
        var inpt = {
            block: 'b-form-input',
            mods: { theme: 'grey', size: 's' },
            content: { elem: 'input' }
        };

        if ( elem ) {
            inpt.mix = [{ block: 'b-filter-condition', elem: elem, mods: { 'type': 'input' } }];
        }

        return inpt;
    },

    checkAlone: function() {
        if ( !this.rows.lenth ) {
            return;
        }

        var minus = this.rows[0].minus;
        if ( !minus ) {
            return;
        }

        if ( this.rows.length == 1 ) {
            minus.domElem.hide();
            row.operator.remove();
            //this.setMod(this.findElem(this.rows[0].content, 'row'), 'alone', 'yes');
        }
        else {
            minus.domElem.show();
            //this.delMod(this.findElem('row', 'alone', 'yes'), 'alone');
        }
    },

    addRow: function(after) {
        var cont = [
                !this.rows.length ? '' : {
                    block: 'b-filter-condition',
                    elem: 'operator'
                },
                {
                    block: 'b-filter-condition',
                    elem: 'row'
                }
            ];
        var row = {
                content: $(BEMHTML.apply(cont))
            };

        if ( after ) {
            after.content.after(row.content);
            BEM.DOM.init(row.content);
            var ind = $.inArray(after, this.rows);
            if ( ind >= 0 ) {
                this.rows.splice(ind + 1, 0, row);
            }
        }
        else {
            BEM.DOM.append(this.domElem, row.content);
            this.rows.push(row);
        }

        row.fieldBox = this.findBlockOn(this.findElem(row.content, 'field'), 'b-form-select');
        row.fieldBox.setOptions(this.makeSelectOptions(this.fields, function(k, v) {
            return [k, k];
        }));
        row.fieldBox.on('change', row, this.onFieldChange, this);

        row.editor = this.findElem(row.content, 'editor');

        row.operator = this.findBlockInside(this.findElem(row.content, 'operator'), 'b-form-select');

        return row;
    },

    removeRow: function(row) {
        row.content.remove();
        var rowInd = $.inArray(row, this.rows);
        if ( rowInd >= 0 ) {
            this.rows.splice(rowInd, 1);
        }

        this.checkAlone();
    },

    getRowConfig: function(r) {
        return [r.field.name, r.operation, r.getValue && r.getValue() ];
    },

    getConfig: function() {
        var rs = this.rows.slice(0),
            res = this.getRowConfig(rs.shift()),
            next = null;

        while( next = rs.shift() ) {
            res = [
                next.operator.val(),
                [
                    res,
                    this.getRowConfig(next)
                ]
            ];
        }

        return res;
    },

    fromConfig: function(conf) {
        if ( !conf ) {
            return;
        }
        if ( $.inArray(conf[0], ['AND', 'OR', 'NOR']) >= 0 ) {

        }
        else {
            this.rows[0].fieldBox.val(conf[0]);
        }
    }
});

})();
