(function () {
    'use strict';

    BEM.DOM.decl({block: 'b-form-address', modName: 'error', modVal: 'yes'}, {
        onSetMod: {
            js: function () {
                this.formIsLoading = true;

                var blocksInside = this.findBlocksInside('b-form-select').concat(this.findBlocksInside('b-form-input'));

                this.__base();

                blocksInside.forEach(function (block) {
                    block.on('change', function () {
                        if (!this.formIsLoading) {
                            this.hideError();
                        }
                    }, this);
                }, this);

                this.findBlockOutside('b-form').on('redraw', function () {
                    if (this.hideError) {
                        this.hideError();
                    }
                }, this);
            }
        },

        showError: function (text) {
            if (!this._errorPopup) {
                this._errorPopup = this.findBlockInside('form-error', 'b-popupa');
            }

            if (text && this._errorPopup) {
                this._errorPopup.setContent(text);
            }

            this.setMod('error', 'yes');

            if (this._errorPopup) {
                this._errorPopup.show(this.elem('tbl'));
            }

            this.elem('input').focus();
        },

        hideError: function () {
            if (this._errorPopup) {
                this._errorPopup.hide();
            }

            this.delMod('error');
        },

        _afterBlockInit: function () {
            this.__base.apply(this, arguments);
            this.formIsLoading = false;
        }
    });
})();
