/*global BEM*/
(function () {
    'use strict';

    BEM.DOM.decl('b-form-authority-document', {

        onSetMod: {
            js: function () {
                var _this = this;
                var oldTypeValue = this.params.value && this.params.value.type;

                this.findBlockInside('type', 'b-form-select').on('change', function(/* e */) {
                    var value = this.val();
                    var dts = _this.params.doc_types.filter(function (docType) {
                        return docType.value == value;
                    });

                    var dt = dts.length > 0 ? dts[0] : null;

                    // Assert dt != null

                    _this.elem('number').toggle(!dt.no_number);
                    _this.elem('date').toggle(!dt.no_date);

                    // to force redraw error popup position
                    $( window ).trigger( 'resize' );

                    if ( value != oldTypeValue ) {
                        oldTypeValue = value;
                        var numberControl = _this.findBlockInside('number', 'b-form-input');
                        var datepickerControl = _this.findBlockInside('date', 'b-form-datepicker');

                        numberControl &&
                            numberControl.hideError &&
                            numberControl.hideError();

                        datepickerControl &&
                            datepickerControl.hideError &&
                            datepickerControl.hideError();
                    }
                });

                if (this.params.value) {
                    var select = this.findBlockInside('type', 'b-form-select');
                    select.preventErrorHide();
                    select.val(this.params.value.type);

                    this.findBlockInside('number', 'b-form-input').val(this.params.value.number);
                    this.findBlockInside('date', 'b-form-datepicker').val(this.params.value.date);
                }
            }
        }

    });
})();
