(function () {

var bicCache = {};

BEM.DOM.decl('b-form-bank-account', {

    onSetMod : {
        'js' : function() {
            var _this = this,
                bicInputBlock = this.findBlockInside('bic', 'b-form-input');

            if ( bicInputBlock != null ) {
                bicInputBlock.setMod( 'prevent-hide-notification-on-change', 'yes' );

                bicInputBlock.on && bicInputBlock.on('change', function(e) {
                    if (this.val().length == 9) {
                        _this.checkBic( this.val(), function (data) {
                            _this.findBlockInside('cs', 'b-form-input').val(data.correspondentaccount);
                            _this.findBlockInside('name', 'b-form-input').val(data.pretty_name);
                            bicInputBlock.hideError();
                        }, function (data) {
                            bicInputBlock.showError(
                                BEM.I18N('b-form-bank-account', 'invalid-bic')
                            );
                        });
                    } else {
                        bicInputBlock.showHint(
                            BEM.I18N('b-form-bank-account', 'invalid-bic-should-be-9-chars')
                        );
                    }
                });
            }
        }
    },

    checkBic: function ( bic, success, fail ) {
        if ( bic in bicCache ) {
            var result = bicCache[bic];

            if ( result ) {
                success.apply( this, [ result ] );
            } else {
                fail.apply( this, [ result ] );
            }

        } else {

            $.ajax({
                type: "POST",
                url: '/banks/by_bic',
                dataType: 'json',
                data: {bic: bic}
            }).success(function(data) {
                if (data && typeof(data) == 'object' && data.error) {
                    alert(data.error);
                    return;
                };

                bicCache[ bic ] = data;

                if (data) {
                    success.apply( this, [data] );
                } else {
                    fail.apply( this, [data] );
                }
            }).error(function(data) {
                alert(data.responseText);
            });
        }
    }

});

})();
