(function (BEM) {
    'use strict';

    BEM.DOM.decl('b-form-checkbox', {
        showError: function (msg) {
            if (msg) {
                this._errorMsg = msg;
            } else {
                msg = this._errorMsg;
            }
            if (this._popup) {
                this._popup.setContent(msg);
            } else {
                BEM.DOM.append(this.domElem, BEMHTML.apply({
                    block: 'b-popupa',
                    mix: [{
                        block: 'b-form-checkbox',
                        elem: 'error-hint'
                    }],
                    mods: {
                        theme: 'feffd6',
                        direction: 'up',
                        autoclosable: 'no'
                    },
                    content: [
                        {elem: 'tail'},
                        {elem: 'shadow'},
                        {elem: 'content', content: msg}
                    ]
                }));

                this._popup = this.findBlockInside('b-popupa');
            }

            this.setMod('error', 'yes');

            // Чекбоксов может быть в форме несколько с одним названием и ошибку нужно прятать
            // при изменении любого из них
            var checkboxes = this.findBlockOutside('b-form').findBlocksInside('b-form-checkbox');
            var name = this.elem('checkbox').attr('name');
            checkboxes.forEach(function (block) {
                if (block.elem('checkbox').attr('name') === name) {
                    block.on('change', this.hideError, this);
                }
            }, this);

            this._popup.show(this.domElem);
        },
        hideError: function () {
            this._errorMsg = null;
            this.delMod('error');
            this._popup &&
                this._popup.hide();
        },
        destruct: function () {
            this._popup &&
                this._popup.destruct();

            this.__base.apply(this, arguments);
        }
    });
})(BEM);
