(function () {
    'use strict';

    BEM.DOM.decl('b-form-clid-settings', {
        onSetMod: {
            js: function () {
                this._errorList = [];
                this.__base.apply(this, arguments);
            }
        },

        destruct: function () {
            this.hideError();
            this.__base.apply(this, arguments);
        },

        /**
         * @public
         * @param {string} text текст ошибки
         **/
        showError: function (text) {
            var errorPopupList = this.findBlocksInside('b-popupa');

            if (errorPopupList === null) {
                return;
            }
            this.afterCurrentEvent(function () {
                // нужно, чтобы попапы с ошибками показывались (и позиционировались)
                // после того как все блоки проинициализируются и откроются/закроются
                // т.к. открываются/закрываются они в js
                errorPopupList.forEach(this._showError.bind(this, text));
            }, this);
        },

        /**
         * @public
         **/
        hideError: function () {
            if (this._errorList.length > 0) {
                this._errorList.forEach(this._hideError.bind(this));
            }
        },

        /**
         * @protected
         **/
        _showRadio: function () {
            this.__base.apply(this, arguments);
            this.hideError();
        },

        /**
         * @private
         * @param {string} text
         * @param {b-popupa} bPopup
         **/
        _showError: function (text, bPopup) {
            this.setMod('error', 'yes');
            var $radioItem = bPopup.domElem.parent();
            var type = this.getMod($radioItem, 'type');

            if (type) {
                // с серверсайда приходят с подчеркиваниями,
                // а в БЭМе моды не могут быть с подчеркиваниями
                type = type.replace('-', '_');
            }

            if (text && text[type] !== undefined) {
                bPopup.setContent(text[type]);
            }

            var bFormBlock = this.findBlockInside($radioItem, 'b-form-radio') ||
                             this.findBlockInside($radioItem, 'b-form-select');
            var error = {
                    bPopup: bPopup,
                    bFormBlock: bFormBlock,
                    $radioItem: $radioItem,
                    type: type
                };
            var onChange = this._hideError.bind(this, error);

            error.onChange = onChange;
            this._errorList.push(error);

            this.setMod(error.$radioItem, 'error', 'yes');
            bFormBlock.on('change', onChange);
            bPopup.show(bFormBlock.domElem);
        },

        /**
         * @private
         * @param {object} error {bPopup, bFormBlock, $radioItem, onChange}
         **/
        _hideError: function (error) {
            error.bPopup.hide();
            error.bFormBlock.un('change', error.onChange);
            this.delMod(error.$radioItem, 'error');

            this._errorList = this._errorList.filter(function (errorOpt) {
                return errorOpt.type !== error.type;
            });
            if (this._errorList.length === 0) {
                this.delMod('error');
            }
        }

    });
})();
