(function () {
    'use strict';

    BEM.DOM.decl('b-form-clid-settings', {
        onSetMod: {
            js: function () {
                this._checkbox = this.findBlockInside('checkbox', 'b-form-checkbox');
                this._checkbox.on('change', this._onChange, this);
                this._showRadio(this._checkbox.isChecked());

                this._bFormRadioList = this.findBlocksInside('radio', 'b-form-radio');
                if (this._bFormRadioList) {
                    this._bFormRadioList.forEach(this._bindItemChange, this);
                }

                this._bFormSelectList = this.findBlocksInside('radio', 'b-form-select');
                if (this._bFormSelectList) {
                    this._bFormSelectList.forEach(this._bindSelectChange, this);
                }
            }
        },

        /**
         * @protected
         * @param {boolean} visible
         * @param {boolean} animate
         **/
        _showRadio: function (visible, animate) {
            var show = animate ? 'slideDown' : 'show',
                hide = animate ? 'slideUp' : 'hide';
            this.elem('radio')[visible ? show : hide]();
            this.setMod('open', visible ? 'yes' : '');
        },

        /**
         * @private
         * @param {b-form-radio} radioItem
         **/
        _bindItemChange: function (radioItem) {
            radioItem.on('change', this._onItemChange, this);
        },

        /**
         * @private
         * @param {b-form-select} select
         **/
        _bindSelectChange: function (select) {
            select.on('chage', this._onItemChange, this);
        },

        /**
         * @private
         **/
        _onItemChange: function () {
            this.afterCurrentEvent(function () {
                this.trigger('change');
            }, this);
        },

        /**
         * @private
         **/
        _onChange: function () {
            this._showRadio(this._checkbox.isChecked(), true);
            this.trigger('change');
        }
    });
})();
