(function(window, BEM, $, undefined){

    'use strict';

    BEM.DOM.decl('b-form-colorpicker', {
        onSetMod: {
            js: function() {
                var _this = this,
                    color = '';

                this.__base.apply(this);

                function getBgColor(el) {
                    return _this._normalizeColor($(el).css('background-color'));
                }

                this.bindTo('palette', 'mouseenter', function(/* e */) {
                    color = _this.findBlockInside('b-form-input').val();
                });

                this.bindTo('palette', 'mouseleave', function(/* e */) {
                    _this.val(color);
                });

                this.bindTo('palette', 'mousemove', function(e) {
                    _this.val(getBgColor(e.target));
                });

                this.bindTo('palette', 'mousedown', function(e) {
                    color = getBgColor(e.target);
                });

                this.bindTo('palette', 'click', function(/* e */) {
                    _this.findBlockInside('b-form-input').focus();
                });
            }
        }
    });

})(window, BEM, jQuery);
