/*jslint bitwise: true, plusplus: true, nomen:true*/
/*globals jQuery, BEM*/

(function ($, BEM) {

    'use strict';

    BEM.DOM.decl('b-form-colorpicker', {
        onSetMod: {
            js: function () {
                this._onSampleMouseDown = $.proxy(this._onSampleMouseDown, this);
                this._onSampleClick = $.proxy(this._onSampleClick, this);
                this._onInputBlur = $.proxy(this._onInputBlur, this);
                this._onInputChange = $.proxy(this._onInputChange, this);

                this._input = this.findBlockInside('b-form-input');

                this.oldVal = this.val();
                this.sampleClickInProgress = false;

                this.bindTo('sample', 'mousedown', this._onSampleMouseDown);
                this.bindTo('sample', 'click', this._onSampleClick);

                this._input.bindTo('input', 'blur', this._onInputBlur);
            },

            disabled: function (modName, modVal) {
                if (modVal === 'yes') {
                    this._input.setMod('disabled', 'yes');
                } else {
                    this._input.delMod('disabled');
                    this._input.validate();
                }

                this.trigger('change');
            }
        },

        destruct: function () {
            if (this._input) {
                this._input.hideError();
                this._input.destruct();
            }
            this.__base.apply(this, arguments);
        },

        _onSampleMouseDown: function () {
            this.sampleClickInProgress = true;
        },

        _onSampleClick: function () {
            if (!this.hasMod('disabled', 'yes')) {
                this.sampleClickInProgress = false;
                this.elem('palette').toggle();
                $(this._input.elem('input')).focus();
            }
        },

        _onInputBlur: function () {
            var val;

            if (!this.sampleClickInProgress) {
                this.elem('palette').hide();

                val = this.val();

                if (this._input.isValid()) {
                    this.val(this._normalizeColor(val));
                }

                if (this.oldVal !== val) {
                    this.oldVal = val;
                    this.trigger('change');
                }
            }
        },

        _normalizeColor: function (s) {
            if (s === '' || s === null) { return ''; }

            if (/^[0-9a-f]{6}$/i.test(s)) { return s.toUpperCase(); }

            if (/^#[0-9a-f]{6}$/i.test(s)) { return s.substr(1).toUpperCase(); }

            if (/^[0-9a-f]{3}$/i.test(s)) { return doubleChars(s.toUpperCase()); }

            if (/^#?[0-9a-f]{3}$/i.test(s)) { return doubleChars(s.substr(1).toUpperCase()); }

            return (s.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/) || [])
                .map(function (n, i) {
                    if (i === 0) { return ''; }
                    return dec2hex(n);
                })
                .join('').toUpperCase();
        },

        val: function () {
            var val,
                oldVal;

            if (arguments.length === 0) {
                return this._input.val();
            }

            val = arguments[0];
            oldVal = this._input.val();

            this._input.val(val);
            this.elem('sample').css('background-color', '#' + val);
            if (!this.hasMod('disabled', 'yes') && val !== oldVal) { this._input.validate(); }
        },

        isValid: function () {
            return this._input.isValid();
        },

        validate: function () {
            this._input.validate();
        }
    });

    function fillZero(s) {
        if (s.length > 1) { return s; }
        return '0' + s;
    }

    function dec2hex(n) {
        return fillZero((n|0).toString(16));
    }

    function doubleChars(s) {
        return s.toString().split('').map(function (c) { return c + c; }).join('');
    }

})(jQuery, BEM);
