(function () {
    'use strict';
    BEM.DOM.decl('b-form-contract-type', {

        onSetMod: {
            'js': function() {
                var _this = this,
                    formSelect = this.findBlockInside('b-form-select'),
                    oldVal;

                if (this.params.value) {
                    this._checkboxInitial = _this.params.value.cooperation_type;
                    formSelect.val(this.params.value.country);
                    this._showCooperationTypes(this.params.value.country);
                    delete this.params.value.country;
                }

                var form = this.findBlockOutside( 'b-form' );
                if (form) {
                    form.on('redraw', function () {
                        if (_this.hideError) {
                            _this.hideError();
                        }
                    });
                }

                oldVal = formSelect.val();
                formSelect.on('change', function (e, data) {
                    var val = this.val();

                    if (data.prev !== -1 && val != oldVal) {
                        oldVal = val;
                        _this._showCooperationTypes(val);
                    }
                });
            }

        },

        /**
         * @param {string} val
         * @return {array:object} - [{name, value}]
         **/
        _getFields: function (val) {
            var contracts = this.params.ct,
                countryContracts = this.params.country_cts,
                fields,
                values;

            function formatField(name) {
                return {name: name, value: contracts[name]};
            }

            if (val && countryContracts) {
                values = countryContracts[val] || countryContracts['default'];
                fields = values.map(formatField);
            }

            return fields;
        },

        _showCooperationTypes: function (val) {
            var bemjson,
                bFormRadiobox,
                coop_types;

            bemjson = {
                block: 'b-form-contract-type',
                elem: 'cooperation-types',
                contract: this._checkboxInitial,
                name: this.params.name,
                error: this.params.errors && this.params.errors.ct,
                fields: this._getFields(val)
            };

            bFormRadiobox = this.findBlockInside('cooperation-types', 'b-form-radiobox');
            coop_types = this.elem('cooperation-types');
            BEM.DOM.after(coop_types, BEMHTML.apply(bemjson));
            if (bFormRadiobox) {
                bFormRadiobox.destruct();
            }
            coop_types.remove();
            this.dropElemCache('cooperation-types');
        }
    });
})();
