(function () {
    'use strict';
    BEM.DOM.decl('b-form-datepicker', {

        onSetMod: {
            js: function () {
                this._inputControl = this.findBlockOn('fake-input', 'b-form-input');
                this._bForm = this.findBlockOutside('b-form');
                this.popup = this.findBlockInside('b-popupa');

                var _this = this;

                if (this.bForm && this.popup) {
                    this._bForm.on('submit', function () {
                        _this.popup.hide();
                    });
                }

                /*
                 * jQuery datepicker replaces select's on month/year change
                 * so they dont belong .b-popupa anymore it causes outside-click.
                 *
                 * Can be fixed by several ways:
                 *   - setTimeout at jQuery calendar handler
                 *   - stopPropagation at jQuery calendar handler (very unsafe)
                 *   - mark click event and use the mark to ignore outside-click
                 *
                 * Fastfix: using autoclosable: 'no' and {elem: 'close'}
                popup.on('outside-click', function (e) {
                    if (_this.ignoreOutsideClick) {
                        e.preventDefault();
                    }
                    _this.mouseDown = false;
                    _this.ignoreOutsideClick = false;
                });
                 */

                this.popup.on('show', this.onPopupShow, this);
                this.popup.on('hide', this.onPopupHide, this);

                this.calendar = this.findBlockInside('b-calendar')
                    .on('change', this._onCalendarChange, this)
                    .on('clickOnMonthNav', function () {
                        _this.ignoreOutsideClick = true;
                    });

                var inputElem = this._inputControl.elem('input');
                inputElem.on('mousedown', function () {
                    _this.mouseDown = true;
                });
                // for some reason this._inputControl thinks its already
                // focused at first time thus event 'focus' dont
                // fires at first time
                inputElem.on('focus', function () {
                    _this.ignoreOutsideClick = _this.mouseDown;

                    _this.popup.show(inputElem);
                    _this._inputControl.hideError();
                });
            }
        },

        onPopupShow: function () {
            this.bindToDoc('click', this.onDocClick);
            this.bindToDoc('focusin', this.onDocFocusin);
            this.bindToDoc('keyup', this.onDocKeyUp);
        },

        onDocKeyUp: function (e) {
            if (e.keyCode == 27) {
                this.popup.hide();
            }
        },

        onPopupHide: function () {
            this.unbindFromDoc('click');
            this.unbindFromDoc('focusin');
            this.unbindFromDoc('keyup');
        },

        onDocClick: function () {
            this.mouseDown = false;
            this.ignoreOutsideClick = false;
        },

        onDocFocusin: function () {
            var ae = document.activeElement;

            if (document.body != ae) {
                if (!$.contains(this.popup.domElem.get(0), ae)) {
                    this.popup.hide();
                }
            }
        },

        getHumanValueFromISO: function (ISOValue) {
            if (!ISOValue || ISOValue === 'undefined') {
                return;
            }
            var yearMonthDate = ISOValue.split('-');

            return yearMonthDate[2] + '.' + yearMonthDate[1] + '.' + yearMonthDate[0];
        },

        hidePopup: function () {
            this.popup && this.popup.hide();
        },

        hideError: function () {
            this._inputControl.hideError && this._inputControl.hideError();
        },

        showError: function () {
            this._inputControl.showError && this._inputControl.showError.apply(this, arguments);
        },

        val: function (value) {
            var inputElem = this.elem('input');
            if (value == null) {
                return inputElem.val();
            } else {
                inputElem.val(value);
                this.calendar.val(value);
                this._inputControl
                    .val(this.getHumanValueFromISO(value));
            }
        },

        destruct: function () {
            this.popup.destruct();
            if (this._inputControl) {
                this._inputControl.destruct();
            }
            this.__base.apply(this, arguments);
        },

        _onCalendarChange: function (e) {
            var val = e.block.val();

            this._inputControl.val(this.getHumanValueFromISO(val));
            this._inputControl.trigger('change');
            this.elem('input').val(val).trigger('change');
            this.popup.hide();
            this.trigger('change');
        }
    });
})();
