(function () {
    'use strict';

    /**
     * Логика
     *
     * При выборе пункта "Прочее" в меню (проверяем по значению, оно должно быть равно 6)
     * показываем текствое поле для ввода, в остальных случаях - прячем его
     */
    BEM.DOM.decl('b-form-entity-types', {

        onSetMod: {
            js: function () {
                this._input  = this.findBlockInside('text', 'b-form-input');
                this._select = this.findBlockOn('select', 'b-form-select');

                this._check();
                this._checkIfEntrepreneur();

                this._select.on('change', this._change, this);

                if (this.params.errorText) {
                    this._select.preventErrorHide();
                }
            }
        },

        _change: function () {
            this._checkIfEntrepreneur();

            if (this._check()) {
                this._changeState();

                // Если инпут прячется - сбрасываем ошибку и значение
                if (this._checkInput() && this._input.hideError) {
                    this._input.hideError();
                    this._input.val('');
                }
            }
        },

        // Проверка на необходимость смены состояния input-a
        _check: function () {
            return this._checkInput() === this._checkOption();
        },

        _checkIfEntrepreneur: function () {
            var _this = this;
            var form = this.findBlockOutside('b-wizard-form');
            if (form) {
                form.findBlocksInside('b-form-input').forEach(function (blockInput) {
                    if (blockInput.name() === _this.params.kppFieldName) {
                        if (_this._select.val() === _this.params.entrepreneurValue) {
                            blockInput.domElem.hide();
                        } else {
                            blockInput.domElem.show();
                            blockInput.delMod('disabled');
                            var label = blockInput.findBlockInside('b-form-field-label');
                            if (label) {
                                label.setMod('optional', 'no');
                            }
                        }
                    }
                });
            }
        },

        // Проверка, спрятан ли input
        _checkInput: function () {
            return this.getMod(this.elem('text'), 'hidden') === 'yes';
        },

        // Проверка списка на нужное значение, для показа input-a
        _checkOption: function () {
            return this._select.val() === this.params.itemCustomValue;
        },

        // Смена состояния input-a
        _changeState: function () {
            this.toggleMod(this.elem('text'), 'hidden', 'yes', 'no');
        }

    });
})();
