(function () {
    'use strict';

    BEM.DOM.decl('b-form-global-clid-settings', {
        onSetMod: {
            js: function () {
                // Коллекции дочерних блоков
                this.list = {};

                // Вешаем обработчики
                var buttons = this.findBlocksInside('b-form-button');
                buttons.forEach(this._bindButtonClick, this);

                var selects = this.findBlocksInside('b-form-select');
                selects.forEach(this._bindSelectChange, this);
            }
        },

        /**
         * Заполняет хеш this.list и вешает слушатель события на кнопку
         *
         * @private
         * @param {bem-block} button
         **/
        _bindButtonClick: function (button) {
            var type = button.params.type;
            var val = button.params.val;

            if (!(type in this.list)) {
                this.list[type] = this.findBlocksInside('child', {
                    block: 'b-form-radio',
                    modName: 'type',
                    modVal: type
                });
            }

            button.on('click', this._setValues.bind(this, type, val));
        },

        /**
         * Заполняет хеш this.list и вешает слушатель события на кнопку
         *
         * @private
         * @param {bem-block} select
         **/
        _bindSelectChange: function (select) {
            var type = select.params.type;

            if (!(type in this.list)) {
                this.list[type] = this.findBlocksInside('child', {
                    block: 'b-form-select',
                    modName: 'type',
                    modVal: type
                });
            }

            select.on('change', this._onSelectChange, this);
        },

        /**
         * @private
         * @param {event} e
         **/
        _onSelectChange: function (e) {
            this._setValues(e.block.params.type, e.block.val());
        },

        /**
         * @private
         * @param {string} type
         * @param {string} val
         **/
        _setValues: function (type, val) {
            this.list[type].forEach(function (block) {
                block.val(val);
            });
        }
    });
})();
