(function () {
    'use strict';

    BEM.DOM.decl({block: 'b-form-pfr', modName: 'error', modVal: 'yes'}, {
        onSetMod: {
            js: {
                inited: function () {
                    this.__base.apply(this, arguments);
                    this._errorPopup = this.findBlockOn('error', 'b-popupa');
                }
            }
        },

        showError: function (text) {
            this.setMod('error', 'yes');
            if (this._errorPopup !== null) {
                if (typeof text !== 'undefined') {
                    this._errorPopup.setContent(text);
                }
                this._errorPopup.show(this.elem('controls'));
            }
        },

        hideError: function () {
            this.delMod('error');
            this._errorPopup && this._errorPopup.hide();
        },

        _onInputChange: function () {
            this.__base.apply(this, arguments);
            this.hideError();
        }
    });
})();
