(function () {
    'use strict';

    var _ = require('lodash');
    var indexOf = _.indexOf;

    var KEYS = {
        backspace: 8,
        arrowLeft: 37,
        arrowRight: 39
    };

    BEM.DOM.decl('b-form-pfr', {
        onSetMod: {
            js: {
                inited: function () {
                    this._inputs = this.findBlocksInside('b-form-input');
                    this._inputs.forEach(function (input) {
                        input.on('change', this._onInputChange, this);
                        input.elem('input').on('keydown', this._onInputKeydown.bind(this, input));
                    }, this);
                }
            }
        },

        /**
         * Обработчик изменения занчения input.
         * Если в input максимальное число символов - переводит фокус на слудующий.
         *
         * @param {bemEvent} e
         **/
        _onInputChange: function (e) {
            if (this._preventChange) {
                return;
            }
            var input = e.block;
            var val = input.val();
            var maxLength = parseInt(input.elem('input').attr('maxlength'), 10);
            var index = indexOf(this._inputs, input);

            if (val.length === maxLength) {
                this._focusNext(index);
            }
        },

        /**
         * Обработчик нажатия клавии в input.
         * Если нажали backspace - переводит фокус на предыдущий input.
         *
         * @param {bemBlock} input
         * @param {event} e
         **/
        _onInputKeydown: function (input, e) {
            var keyCode = e.keyCode;
            var val = input.val();
            var index = indexOf(this._inputs, input);

            if (keyCode === KEYS.backspace && val.length === 0) {
                this._focusPrevious(index);
            }
        },

        /**
         * Переводит фокус на следующий input.
         *
         * @param {number} index
         **/
        _focusNext: function (index) {
            var next = this._inputs[index + 1];
            if (typeof next !== 'undefined') {
                next.setMod('focused', 'yes');
            }
        },

        /**
         * Переводит фокус на предыдущий input.
         *
         * @param {number} index
         **/
        _focusPrevious: function (index) {
            var prev = this._inputs[index -1];
            var val;
            if (typeof prev !== 'undefined') {
                this._preventChange = true;
                val = prev.val();
                // чтобы при переходе на предыдущий инпут не выделялся весь текст сразу
                prev.setMod('focused', 'yes').val('').val(val);
                this._preventChange = false;
            }
        }
    });
})();
