(function () {
    'use strict';

    var ajax = require('utils/vow-ajax').ajax;

    BEM.DOM.decl('b-form-ph-payments', {
        onSetMod: {
            js: {
                inited: function () {
                    this._initControls();

                    this._bankbicHint = BEM.I18N('b-form-ph-payments', 'BIC should contain 9 characters');

                    this._typeRadio.on('change', this._onTypeChange, this);
                    this._inputs.bankbic.on('change', this._onBankbicChange, this);

                    this._loadBankProps();
                }
            }
        },

        /**
         * Создает хеш и список инпутов
         * Создает свойство для контрола типа
         **/
        _initControls: function () {
            // Хеш {имя_контрола:блок_контрола}
            this._inputs = {};
            this._inputList = [];
            this.elem('field').each(function (result, field) {
                var $field = $(field);
                var input = this.findBlockInside($field, 'b-form-input');
                if (input) {
                    this._inputs[this.getMod($field, 'name')] = input;
                    this._inputList.push(input);
                }
            }.bind(this));

            this._typeRadio = this.findBlockInside(this.findElem('field', 'name', 'type'), 'b-form-radio');
        },

        /**
         * Отображает нужные поля и прячет ошибки
         **/
        _onTypeChange: function () {
            var fields = this.params.fieldsToShow[this._typeRadio.val()] || ['type'];
            this._showFields(fields);

            this._inputList.forEach(function (control) {
                control.hideError();
            });
        },

        /**
         * Отображает поля
         *
         * @param {Array} fields Список строк - названий полей
         **/
        _showFields: function (fields) {
            this.setMod(this.elem('field'), 'show', 'no');
            this._inputList.forEach(function (input) {
                input.val('');
            });
            fields.forEach(function (fieldName) {
                var $field = this.elem('field', 'name', fieldName.replace('_', '-'));
                this.setMod($field, 'show', 'yes');
            }, this);
        },

        /**
         * При изминении БИК-а
         * Запрашивает данные о банке и прячет ошибки
         * (т.к. другие поля зависимы от БИК-а и не могут быть валидными, если БИК не указан)
         **/
        _onBankbicChange: function () {
            this._checkBankbicHint();
            if (!this._inputs.bankbic.getMod('notification')) {
                this._loadBankProps();
                this._inputList.forEach(function (input) {
                    input.hideError();
                }, this);
            }
        },

        /**
         * Запрашивает данные о банке по БИК-у
         **/
        _loadBankProps: function () {
            var url = this.params.bankbicURL;
            var bankbic = this._inputs.bankbic.val();

            if (!this.params.bankbicURL || !bankbic) {
                return;
            }

            var type = this._typeRadio.val();

            ajax({
                type: 'POST',
                url: url,
                data: {bic: bankbic}
            }).done(
                this._onBankPropsRequestDone.bind(this, type, bankbic),
                this._onBankPropsRequestFail.bind(this)
            );
        },

        /**
         * Отображает подсказку около поля, если длина введенного БИК-а не равна 9
         **/
        _checkBankbicHint: function () {
            var bankbic = this._inputs.bankbic.val();
            if (!bankbic || bankbic.length !== 9) {
                if (this._inputs.bankbic.getMod('notification') !== 'hint') {
                    this._showBankbicNotification('hint', this._bankbicHint);
                }
            } else {
                this._inputs.bankbic.hideHint();
            }
        },

        /**
         * При удачном выполенении запроса о данных банка
         * Отображает данные в соответствующих полях
         *
         * @param {string} type
         * @param {string} bankbic
         * @param {object} data
         **/
        _onBankPropsRequestDone: function (type, bankbic, data) {
            // если с момента запроса тип или бик мы уже поменяли
            if (type !== this._typeRadio.val() || bankbic !== this._inputs.bankbic.val()) {
                return;
            }
            // если ничего не пришло
            if (data === null || typeof data === 'undefined') {
                this._onBankPropsRequestFail(data);
                return;
            }

            // Проставляет корреспондентский счет
            if (this.hasMod(this.elem('field', 'name', 'correspondent-account'), 'show', 'yes')) {
                this._inputs['correspondent-account'].val(data.correspondentaccount);
            }

            // Проставляет название/отделение банка
            if (this.hasMod(this.elem('field', 'name', 'bank-name'), 'show', 'yes')) {
                this._inputs['bank-name'].val(data.pretty_name);
            } else if (this.hasMod(this.elem('field', 'name', 'sberbank-branch'), 'show', 'yes')) {
                this._inputs['sberbank-branch'].val(data.pretty_name);
            }
        },

        /**
         * При неудачном выполенении запроса о данных банка
         * Отображает либо ошибку, которая пришла с сервера, либо что БИК неправильный
         *
         * @param {event} e
         **/
        _onBankPropsRequestFail: function (e) {
            this._showBankbicNotification('error', e && e.error || BEM.I18N('b-form-ph-payments', 'Invalid BIC'));
        },

        /**
         * Отображает предупреждение или ошибку у поля БИК
         *
         * @param {string} type error|hint
         * @param {string} text Текст ошибки/предупреждения
         **/
        _showBankbicNotification: function (type, text) {
            this._inputs.bankbic.setMod('prevent-hide-notification-on-change', 'yes');
            if (type === 'hint') {
                this._inputs.bankbic.showHint(text);
            } else if (type === 'error') {
                this._inputs.bankbic.showError(text);
            }
            this._inputs.bankbic.delMod('prevent-hide-notification-on-change');
        }
    });
})();
