(function (BEM) {
    'use strict';

    BEM.DOM.decl({block: 'b-form-radio', modName: 'type', modVal: 'multicheck'}, {
        onElemSetMod: {
            'button': {
                'checked': {
                    'yes': function(elem) {
                        this.setMod(elem.next(), 'next-for-checked', 'yes');

                        this.findElem(elem, 'checkbox').attr('checked', true);

                        this.trigger('change', {
                            current: elem
                        });
                    },

                    '': function(elem) {
                        this.delMod(elem.next(), 'next-for-checked');

                        this.findElem(elem, 'checkbox').attr('checked', false);

                        this.trigger('change', {
                            current: elem
                        });
                    }
                },
                'disabled': function(elem, modName, modVal) {
                    elem.find(this.buildSelector('checkbox')).attr('disabled', modVal == 'yes');
                }
            }
        },

        uncheckAll: function() {
            var button = this.elem('button', 'checked', 'yes');

            this
                .delMod(button, 'checked')
                .findElem(button, 'checkbox').attr('checked', false);

            return this;
        },

        val: function(value) {
            var checkboxes = this.elem('checkbox');
            if (typeof value === 'undefined') {
                return checkboxes.toArray().map(function(elem) {
                    return {
                        value: elem.value,
                        checked: elem.checked
                    };
                });
            } else {
                var _this = this;
                this.uncheckAll();
                value.forEach(function (elem) {
                    checkboxes.each(function () {
                        if (elem.value === this.value) {
                            _this.setMod(_this.__self._getButtonByElem($(this)), 'checked', 'yes');
                        }
                    });
                });

                return this;
            }
        }
    },{
        live: function() {
            this.__base.apply(this, arguments);
            this
                .liveBindTo('checkbox', 'leftclick', function(e) {
                    if (!e.target.disabled) {
                        var button = this.__self._getButtonByElem(e.data.domElem);
                        this
                            .setMod(button, 'focused', e.target.checked ? 'yes' : '')
                            .setMod(button, 'checked', e.target.checked ? 'yes' : '');
                    }
                })
                .liveBindTo('checkbox', 'change', function(e) {
                    this._onChange(e);
                })
                .liveBindTo('checkbox', 'focusin focusout', function(e) {
                    this.setMod(
                        this.__self._getButtonByElem(e.data.domElem),
                        'focused',
                        e.type == 'focusin' ? 'yes' : '');
                });

            return false;
        }
    });
})(BEM);
