(function (BEM) {
    'use strict';

    BEM.DOM.decl('b-form-radio', {
        showError: function (msg) {
            if (this._popup) {
                this._popup.setContent(msg);
            } else {
                BEM.DOM.append(this.domElem, BEMHTML.apply({
                    block: 'b-popupa',
                    mix: [{
                        block: 'b-form-radio',
                        elem: 'error-hint'
                    }],
                    mods: {
                        theme: 'feffd6',
                        direction: 'up',
                        autoclosable: 'no'
                    },
                    content: [
                        {elem: 'tail'},
                        {elem: 'shadow'},
                        {elem: 'content', content: msg}
                    ]
                }));

                this._popup = this.findBlockInside('b-popupa');
            }

            this.setMod('notification', 'yes');
            this.on('change', this.hideError, this);
            this._popup.show(this.domElem);
        },
        hideError: function () {
            this.delMod('notification');
            this._popup &&
                this._popup.hide();
        },
        destruct: function () {
            this._popup &&
                this._popup.destruct();

            this.__base.apply(this, arguments);
        }
    });
})(BEM);
