(function (BEM) {
    'use strict';

    var ajax = BEM.blocks['i-promises'].ajax;

    BEM.DOM.decl('b-form-saver', {
        onSetMod: {
            js: function () {
                this.button = this.findBlockInside('button', 'b-form-button');
                this.spin = this.findBlockInside('spin', 'b-spin');

                this.source = this.findBlockInside(this.params.source);
                if (this.params.event) {
                    this.source.on(event, this.onEvent, this);
                }
            },

            progress: function (modName, modVal) {
                if (this.button) {
                    this.button.setMod('disabled', modVal === 'yes' ? 'yes' : '');
                }
                if (this.spin) {
                    this.spin.setMod('progress', modVal === 'yes' ? 'yes' : '');
                }
            }
        },
        _getData: function () {
            var method = this.params.method || 'serialize';
            var data;

            if (!this.source[method] || typeof this.source[method] !== 'function') {
                throw new Error('Source "' + this.params.source + '" does not implement "' + method + '" method');
            }

            data = this.source[method]();
            if (this.params.options) {
                $.extend(data, this.params.options);
            }
            return data;
        },

        onEvent: function () {
            this.setMod('progress', 'yes');
            if (this.button) {
                this.button.setMod('disabled', 'yes');
            }

            var data = this._getData();
            ajax.post(this.params.url, data, this.params.dataType)
                .then(this.onSuccess, this)
                .fail(this.onFail, this);
        },

        onSuccess: function (data) {
            if (data.error) {
                this.onFail(data.error);
                return;
            }
            this.delMod('progress');
            if (this.source.onSuccess) {
                this.source.onSuccess(data);
            }
        },

        onFail: function (e) {
            this.delMod('progress');
            if (this.elem('error')) {
                this.elem('error').text(e.responseText || e);
            }
            if (this.source.onFail) {
                this.source.onFail(e);
            }
        }

    }, {
        live: function () {
            this.liveBindTo('button', 'click', function (e) {
                this.onEvent(e);
            });
        }
    });

})(BEM);
