(function () {
    'use strict';

    /**
     * Возвращает название поля без префикса
     *
     * @private
     * @param {string} prefix
     * @return {string}
     **/
    function removePrefix(prefix) {
        return function (name) {
            return name.replace(prefix, '');
        };
    }

    BEM.DOM.decl('b-form-strategy', {
        onSetMod: {
            js: {
                inited: function () {
                    this._bFieldgroups = this.findBlocksInside('b-fieldgroup');
                    this._$radioMaxMoney = this.elem('max-money');
                    this._getName = removePrefix(this.params.prefix);
                }
            }
        },

        /**
         * Возвращает атрибут name активного инпута или радиокнопки
         * Нужно для b-table-cell-text
         *
         * @public
         * @return {string}
         **/
        name: function () {
            return ['strategy', 'mincpm', 'percent_traffic'];
        },

        /**
         * @public
         * @param {object} value
         **/
        val: function (value) {
            if (typeof value === 'undefined') {
                return this._getValue();
            } else {
                this._setValue(value);
            }
        },

        /**
         * @private
         * @return {object}
         **/
        _getValue: function () {
            var getName = this._getName;

            /**
             * @private
             * @param {object} values
             * @param {object} result
             * @param {string} key
             * @return {object}
             **/
            function formatKeys(values, result, key) {
                result[getName(key)] = values[key];
                return result;
            }

            /**
             * @private
             * @param {object} result
             * @param {block} block
             * @return {object}
             **/
            function addValue(result, block) {
                var value = block.val();
                if (typeof value !== 'undefined') {
                    Object.keys(value).reduce(formatKeys.bind(null, value), result);
                }
                return result;
            }

            var result = {};
            if (this._$radioMaxMoney.prop('checked')) {
                result[getName(this._$radioMaxMoney.attr('name'))] = this._$radioMaxMoney.val();
            } else {
                this._bFieldgroups.reduce(addValue, result);
            }
            return result;
        },

        /**
         * @private
         * @param {object} value
         **/
        _setValue: function (value) {
            var prefix = this.params.prefix;

            /**
             * @private
             * @param {object} values
             * @param {object} result
             * @param {string} key
             * @return {object}
             **/
            function formatKeys(values, result, key) {
                result[prefix + key] = values[key];
                return result;
            }

            if (typeof value === 'object' && value !== null) {
                if (this._$radioMaxMoney.val() === String(value.strategy)) {
                    this._$radioMaxMoney.prop('checked', true).trigger('change');
                } else {
                    value = Object.keys(value).reduce(formatKeys.bind(null, value), {});
                    this._bFieldgroups.forEach(function (block) {
                        block.val(value);
                    });
                }
            }
        }
    });
})();
