(function (BEM) {
    'use strict';

    BEM.DOM.decl('b-help-box', {
        onSetMod: {
            js: function () {
                if (this.hasMod('size', 'm')) {
                    this.setMod(this.elem('hint-wrapper'), 'size', 'm');
                }
            }
        },

        destruct: function () {
            if (this._bPopup) {
                this._bPopup.destruct();
            }
            this.__base.apply(this, arguments);
        },

        _togglePopup: function ($elem) {
            if (!this._bPopup) {
                BEM.DOM.after(this.elem('icon'), BEMHTML.apply({
                    block: 'b-help-box',
                    elem: 'popup',
                    content: this.params.tooltip
                }));
                this._bPopup = this.findBlockOn(this.elem('popup'), 'b-popupa');
            }
            if (typeof $elem !== 'undefined') {
                this._bPopup.show($elem);
            } else {
                this._bPopup.hide();
            }
        }
    }, {
        live: function () {
            this.liveBindTo('icon', 'mouseover', function () {
                this._togglePopup(this.elem('icon'));
            });

            this.liveBindTo('icon', 'mouseout', function () {
                this._togglePopup();
            });
        }
    });
})(BEM);
