(function (BEM, BEMHTML) {
    'use strict';

    var ajax = BEM.blocks['i-promises'].ajax;

    BEM.DOM.decl('b-link-reducer', {
        onSetMod: {
            js: {
                inited: function () {
                    // сохраняем пути до блоков и элементов
                    this._bPopup = this.findBlockInside('b-popupa');
                    this._bSpin = this.findBlockOn(this.elem('spin'), 'b-spin');
                    this._bClipBoard = this.findBlockOn('clipboard', 'b-clipboard');

                    // сохраняем параметры блока
                    this._rendered = false;
                    this._reducerUrl = this.params.reducerUrl || '/s/add';
                    this._linkPathname = this.params.linkPathname || document.location.pathname;
                    this._linkParams = this.params.linkParams || '';
                    this._minParamsLength = parseInt(this.params.minParamsLength, 10) || 256;

                    if (this._bPopup) {
                        this._bPopup.on('show', this._onShow, this);
                    }
                }
            }
        },

        destruct: function () {
            if (this._bPopup) {
                this._bPopup.destruct();
            }
            this.__base.apply(this, arguments);
        },

        /**
         * Обновляет параметры ссылки
         *
         * @param {string} linkParams Заэнкодиные параметры запроса
         **/
        setUrlParams: function (linkParams) {
            this._linkParams = linkParams;
            // если параметры изменились, то нужно отобразить новую ссылку
            this._rendered = false;
        },

        /**
         * Загружает сокращенную ссылку при открытии попапа
         * Сразу загрузку решили не делать, т.к. будет много лишних ссылок в базе
         **/
        _onShow: function () {
            if (this._rendered === false) {
                if (this._bClipboard) {
                    this._bClipBoard.destruct();
                }
                // без таймаута перестает закрываться по аутсайд клику
                this.afterCurrentEvent(function () {
                    this._load();
                    this._showSpin();
                }, this);
            }
        },

        /**
         * Отображает крутилку
         * Загружает сокращенную ссылку, если длина параметров больше минимальной длины для отправки
         **/
        _load: function () {
            if (this._linkParams && this._linkParams.length > this._minParamsLength) {
                ajax({
                    url: this._reducerUrl,
                    data: {
                        page_uri: this._linkPathname,
                        params: this._linkParams
                    }
                }).then(this._onLoad, this).fail(this._onError, this).always(this._hideSpin, this);
            } else {
                // в document.location не всегда есть значения фильтров, поэтому
                // склеиваем ссылку из кусочков
                this._renderClipboard(this._getFullLink());
            }
        },

        /**
         * Отображает крутилку
         **/
        _showSpin: function () {
            this._bPopup.setContent(BEMHTML.apply({
                block: 'b-link-reducer',
                elem: 'spin'
            }));
            this._bSpin = this.findBlockOn(this.elem('spin'), 'b-spin');
        },

        /**
         * Прячет крутилку
         **/
        _hideSpin: function () {
            this._bSpin.delMod('progress');
        },

        /**
         * Возвращает полную ссылку до текущей страницы
         *
         * @return {string}
         **/
        _getFullLink: function () {
            // в IE10 нет document.origin
            var fullLink = [document.location.protocol, '//', document.location.host, this._linkPathname];
            if (typeof this._linkParams === 'string' && this._linkParams.length) {
                fullLink.push('?', this._linkParams);
            }
            return fullLink.join('');
        },

        /**
         * Отображение ошибки
         *
         * @param {string} text
         **/
        _onError: function (text) {
            this._bPopup.setContent(text);
        },

        /**
         * Отображение ссылки или ошибки
         *
         * @param {object} data
         **/
        _onLoad: function (data) {
            if (data.short_link) {
                this.afterCurrentEvent(function () {
                    this._renderClipboard(data.short_link);
                }, this);
            } else if (data.error) {
                this._onError(data.error);
            }
        },

        /**
         * Отображает ссылку
         * Для корректной работы clipboard приходится отрисовывать
         *
         * @param {string} link
         **/
        _renderClipboard: function (link) {
            this._bPopup.setContent(BEMHTML.apply({
                block: 'b-link-reducer',
                elem: 'clipboard',
                content: link
            }));
            this._bClipBoard = this.findBlockOn('clipboard', 'b-clipboard');
            this._rendered = true;
        }
    });
})(BEM, BEMHTML);
