/*global BEM, BEMHTML*/
(function (BEM, BEMHTML, $) {

    'use strict';

    var ajax = $.ajax,
        extend = $.extend,
        Deferred = $.Deferred;

    function postJson(url, data) {
        return ajax({
            type: 'POST',
            url: url,
            dataType: 'json',
            data: data
        });
    }

    function getErrorText(response) {
        return response.responseText;
    }

    function checkForErrors(response) {
        if (response && response.error) {
            return (new Deferred()).reject(response.error);
        }

        return response;
    }

    function slideUp(element) {
        return function () {
            var result = new Deferred();
            $(element).slideUp(200, result.resolve);
            return result.promise();
        };
    }

    function DataProvider(url, sign, params) {
        this.url = url;
        this.sign = sign;
        this.params = params;
    }

    DataProvider.prototype._post = function (action, itemData) {
        var data = extend({}, this.params, {
            action: action,
            value: itemData,
            sign: this.sign
        });

        return postJson(this.url, data);
    };

    DataProvider.prototype.add = function (itemData) {
        // TODO: replace .pipe() with .then() on jQuery 1.8+
        return this._post('add', itemData).pipe(checkForErrors, getErrorText).promise();
    };

    DataProvider.prototype.remove = function (itemData) {
        // TODO: replace .pipe() with .then() on jQuery 1.8+
        return this._post('del', itemData).pipe(checkForErrors, getErrorText).promise();
    };

    function ItemsList(dataProvider, data) {
        this.items = data.sort() || [];
        this._dataProvider = dataProvider;
    }

    ItemsList.prototype.add = function (itemData) {
        var items = this.items;

        // TODO: replace .pipe() with .then() on jQuery 1.8+
        return this._dataProvider.add(itemData).pipe(function(response) {
            var value = (response && response.value) || itemData;
            items.push(value);
            items.sort();
            return itemData;
        }, null);
    };

    ItemsList.prototype.remove = function (itemData) {
        var items = this.items;

        // TODO: replace .pipe() with .then() on jQuery 1.8+
        return this._dataProvider.remove(itemData).pipe(function() {
            items.splice(items.indexOf(itemData), 1);
            return itemData;
        }, null);
    };

    BEM.DOM.decl('b-list-manager', {
        onSetMod: {
            js: function () {
                this._nbsp = String.fromCharCode(160);

                var dataProvider = new DataProvider(this.params.url, this.params.sign, this.params.params);
                this.items = new ItemsList(dataProvider, this.params.data);

                this.btnShow = this.findBlockInside('switcher-link', 'b-link');
                this.popup   = this.findBlockInside('popup', 'b-popupa');
                this.input   = this.findBlockInside('input', 'b-form-input');
                this.btnAdd  = this.findBlockInside('button', 'b-form-button');
                this.spinner = this.findBlockInside('spin', 'b-spin');
                this.content = this.elem('content');
                if (this.input && typeof this.input.getPopup === 'function') {
                    this.fixAutocompleteClick();
                }

                this.btnShow.on('click', this.onShowClick.bind(this));
                this.elem('form').on('submit', this.onSubmit.bind(this));
                this.elem('form').delegate('.b-list-manager__remove', 'click', this.onRemoveClick.bind(this));
                if (this.input) {
                    this.popup.on('hide', this.onPopupHide.bind(this));
                }

                this.updateLinkLabel(); // TODO: процедура(!) без параметров(!)

            },

            progress: function (modName, modVal) {
                if (modVal == 'yes') {
                    this.input.setMod('disabled', 'yes');
                    this.btnAdd.domElem.hide();
                    this.spinner.setMod('progress', 'yes');
                    this.spinner.domElem.show();
                } else {
                    this.spinner.domElem.hide();
                    this.spinner.delMod('progress');
                    this.btnAdd.domElem.show();
                    this.input.delMod('disabled');
                }
            }
        },

        onShowClick: function () {
            this.updateList();
        },

        onSubmit: function (e) {
            var _this = this;

            this.setMod('progress', 'yes');

            this.items.add(this.input.val())
                .pipe(this.updateList.bind(this), this.showError.bind(this))
                .pipe(function () { _this.input.val(''); }, null)
                .always(function () { _this.delMod('progress'); });

            e.preventDefault();
        },

        onRemoveClick: function (e) {
            var item = $(e.target).closest('li'),
                itemSpin = item.find('.b-spin').bem('b-spin'),
                itemRemoveIcon = item.find('.b-list-manager__remove');

            itemSpin.setMod('progress', 'yes');
            itemSpin.domElem.show();
            itemRemoveIcon.hide();
            item.addClass('removing');

            this.items.remove(item.find('.val').text())
                .pipe(slideUp(item), null)
                .pipe(this.updateList.bind(this), this.showError.bind(this))
                .pipe(null, function () {
                    itemSpin.delMod('progress');
                    itemSpin.domElem.hide();
                    itemRemoveIcon.show();
                    item.removeClass('removing');
                });
        },

        onPopupHide: function () {
            this.input.hideError();
        },

        showError: function (error) {
            this.input.showError(error);
        },

        updateList: function (item) {
            this.content.html(BEMHTML.apply({
                block: 'b-list-manager',
                elem: 'list',
                content: this.items.items,
                readOnly: this.params.readOnly
            }));

            this.updateLinkLabel();

            if (item) {
                var addedItem = this.content.find('li').filter(function(i, v) { return $('.val', v).text() == item; });
                if (addedItem.length) {
                    this.content.scrollTop(addedItem[0].offsetTop);
                    addedItem.addClass('hint');
                }
            }
        },

        updateLinkLabel: function () {
            this.btnShow.domElem.text(this.params.text + ':' + this._nbsp + this.items.items.length);
        },

        fixAutocompleteClick: function () {
            var autocompletePopup = this.input.getPopup();
            if (autocompletePopup) {
                autocompletePopup.domElem.on('click', this.onAutocompletePopupClick.bind(this));
            }
        },

        onAutocompletePopupClick: function (e) {
            e.stopPropagation();
        }
    });

})(BEM, BEMHTML, jQuery);
