(function (BEM) {
    'use strict';

    BEM.DOM.decl('b-media-brand-editor', {
        onSetMod: {
            js: function () {
                this.select = this.findBlockInside('select', 'b-form-select');
                this.cpmInput = this.findBlockInside('cpm-input', 'b-form-input');
                this.removeButton = this.findBlockInside('remove-button', 'b-form-button');

                this.select.on('change', this.onSelectChanged, this);
                this.cpmInput.on('change', this.onInputChanged, this);
                this.removeButton.on('click', this.onRemoveButtonClick, this);
            },

            state: function (modName, modVal) {
                this.trigger('statechange', {bid: this.params.brand.bid, value: modVal});
            }
        },

        onRemoveButtonClick: function () {
            this.trigger('remove', {bid: this.params.brand.bid});
            this.destruct();
        },

        onSelectChanged: function (e, data) {
            var setCpmIndex = 1;
            this.setMod('state', data.index === setCpmIndex ? 'cpm' : 'blocked');
        },

        onInputChanged: function () {
            this.delMod('wrong-cpm');
            this.trigger('cpmchange', {bid: this.params.brand.bid, value: this.cpmInput.val()});
        }
    });

})(BEM);
