(function (BEM) {
    'use strict';

    BEM.DOM.decl('b-media-topic-editor', {
        onSetMod: {
            js: function () {
                this.checkbox = this.findBlockInside('checkbox', 'b-form-checkbox');
                this.saveButton = this.findBlockInside('save-button', 'b-form-button');
                this.input = this.findBlockInside('b-form-input');
                this.label = this.elem('cpm-label');

                this.checkbox.on('change', this.onCheckboxChanged, this);
                this.input.on('change', this.onInputChanged, this);
            }
        },

        onCheckboxChanged: function () {
            var selected = this.checkbox.isChecked();
            this.setMod('editable', selected ? 'yes' : '');
            if (selected) {
                this.input.domElem.find('input').focus();
            }

            this.trigger('selectedchange', {
                selected: selected,
                id: this.params.id
            });
            this.trigger('cpmchange', {
                value: selected ? this.input.val() : '',
                id: this.params.id
            });
        },

        onInputChanged: function () {
            if (this.hasMod('wrong-cpm', 'yes')) {
                this.delMod('wrong-cpm');
            }
            this.trigger('cpmchange', {value: this.input.val(), id: this.params.id});
        },

        setCpmValue: function (value) {
            this.label.text(value);
        }
    });

})(BEM);
