/*global BEM*/
(function () {
    'use strict';

    BEM.DOM.decl('b-modal-form', {
        onSetMod: {
            js: function () {
                this.form = this.findBlockOn('form', 'b-ajax-form');
                this.form.on('action', this._onAction, this);
                this.loader = this.findBlockOn('loader', 'b-progress-popup');

                this._initPopup();

                this.form
                    .on('submit', this._showParanja, this)
                    .on('loaded', this._hideParanja, this)
                    .on('action', function (e, b) {
                        b.name === 'redirect' &&
                            this._showParanja();
                    }, this);
            },

            outdated: {
                yes: function () {
                    this.invalidate();
                    this.afterCurrentEvent(this.delMod.bind(this, 'outdated'));
                }
            }
        },

        /* Нечестный способ заблокировать контролы формы в 2.13 */
        _showParanja: function () {
            if (this._paranja) {
                this._paranja.show();
            } else {
                this._paranja = $('<div class="b-modal-form__paranja"></div>');
                this.form.domElem.append(this._paranja);
            }

            this._blur();
        },

        _hideParanja: function () {
            this._paranja &&
                this._paranja.hide();
        },

        _blur: function () {
            var inputs = this.form.findBlocksInside({block: 'b-form-input', modName: 'focused', modVal: 'yes'});
            var checkboxes = this.form.findBlocksInside({block: 'b-form-checkbox', modName: 'focused', modVal: 'yes'});
            var selects  = this.form.findBlocksInside({block: 'b-form-select', modName: 'focused', modVal: 'yes'});

            [].concat(inputs, checkboxes, selects)
                .forEach(function (block) {
                    block.delMod('focused');
                });
        },

        show: function () {
            if (!this.form.isLoaded()){
                this.loader.show();
                this.form.load().done(this._onLoad.bind(this));
            } else {
                this.popup.show();
            }
        },

        hide: function () {
            this.popup && this.popup.hide();
            this.loader.hide();
        },

        getUrl: function () {
            return this.params.url;
        },

        _onLoad: function () {
            this.form.on('loaded', function () {
                if (this.popup.pos) {
                    setTimeout(this.popup.pos.bind(this.popup), 0);
                }
            }, this);

            this.loader.hide();
            this.popup.show();
            this.afterCurrentEvent(function () {
                // корректируем отображение попапа
                // после загрузки и показа
                if (this.popup.pos) {
                    this.popup.pos();
                }
            }, this);
        },

        _initPopup: function () {
            this.popup = this.findBlockOn('popup', 'b-popupa'),
            this.popup.on('hide', this._onPopupHide, this);
        },

        _onPopupHide: function () {
            this.loader && this.loader.hide();
            if (this.hasMod('invalidate', 'yes')) {
                this.invalidate();
            } else {
                this.form.hideErrors();
            }
        },

        _onAction: function (e, data) {
            if (data.name === 'close') {
                this.hide();
            }
            this.trigger('action', data);
        },

        invalidate: function () {
            this.form.invalidate();
        }
    });
})();
