(function () {
    'use strict';

    BEM.DOM.decl('b-modal-trigger', {
        onSetMod: {
            js: function () {
                this._initBlock();
                this._addListeners();
            }
        },

        _initBlock: function () {
            this._trigger = this._getTrigger();
            // {b-modal-form}
            this._bModalForm = this.elem('form').bem('b-modal-form');
        },

        /**
         * @return {b-form-button}
         */
        _getTrigger: function () {
            return this.findBlockOn('button', 'b-form-button');
        },

        _addListeners: function () {
            this._trigger.on('click', this._onAddClick, this);
            if (this.params.refresh) {
                this._bModalForm.on('action', this._onFormAction, this);
            }
        },

        _onAddClick: function () {
            this.trigger('form-show');
            this._bModalForm.show();
        },

        _onFormAction: function (e, data) {
            if (data.name === 'close' && data.data !== null) {
                var text = data.data[this.params.refresh];
                this._refreshText(text);
            }
        },

        /**
         * @param {string} caption
         **/
        _refreshText: function (caption) {
            var elem = this._trigger.elem('text');

            if (!elem || !elem.length) {
                elem = this._trigger.elem('simple');
            }

            if (elem && elem.length) {
                elem.text(caption);
            }
        }
    });
})();
