BEM.DOM.decl('b-moderate-resolution', {
    onSetMod: {
        'js': function() {
            var that = this;
            this._options = this.findBlocksInside('b-form-checkbox');
            $.each(this._options, function(){
                if ( this.isChecked() ) {
                    that._onChange(this);
                }
                this.on('change', function() {
                    that._onChange(this);
                });
            });
        },
        'disabled': function(modName, modVal) {
            $.each(this._options, function() {
                //this.setMod('checked', '');
                this.setMod('disabled', modVal);
            });
        }
    },
    disable: function() {
        this.setMod('disabled', 'yes');
    },
    enable: function() {
        this.delMod('disabled');
    },
    isAnyChecked: function() {
        return this.hasMod('checked', 'yes');
    },
    _onChange: function(option) {
        var anyChecked = _.any(this._options, function(o) { return o.isChecked(); });
        this.setMod('checked', anyChecked ? 'yes' : '' );
        this.trigger('change');
    }
});

BEM.DOM.decl({block: 'b-moderate-resolution', modName: 'options', modVal: 'single'}, {
    _onChange: function(option) {
        if ( option.isChecked() ) {
            if ( this.__current ) {
                this.__current.toggle();
            }
            else {
                this.setMod('checked', 'yes');
                this.trigger('change');
            }
            this.__current = option;
        }
        else {
            if ( this.__current !== option ) {
                return;
            }
            this.__current = null;
            this.delMod('checked');
            this.trigger('change');
        }
    }
});
