(function (BEM) {
    'use strict';

    BEM.DOM.decl('b-multiformats', {
        onSetMod: {
            js: function () {
                var _this = this;
                this._states = ['horizontal', 'vertical', 'posterVertical', 'posterHorizontal']
                    .reduce(function (rs, field) {
                        var group = _this.findBlockOn('limit-' + field, 'b-fieldgroup');

                        rs[field] = {
                            control: group.findBlockInside('b-form-radio'),
                            src: group,
                            shown: group.getMod('disabled') !== 'yes'
                        };

                        return rs;
                    }, {});

                this._direct = this
                    .findBlockOn('direct', 'pi-form-select')
                    .on('change', this._checkLimits, this);

                this._media = this
                    .findBlockOn('media', 'pi-form-select')
                    .on('change', this._changeDSPState, this);
            }
        },

        showError: function (text) {
            var whichOne = ['horizontal', 'vertical', 'posterVertical'].filter(function (type) {
                return this._states[type].shown;
            }, this);

            whichOne.length &&
                this._states[whichOne[0]].control
                    .showError(text || this.params.error);
        },

        /**
         * Блокирует чекает и дизеблит чекбок,
         * если его значение совподает с блоком медийной рекламы
         */
        _changeDSPState: function () {
            var value = this._media.val();

            this._getDSPList()
                .filter(function (cbox) {
                    if (cbox.val() === value) {
                        return true;
                    } else {
                        cbox.delMod('disabled');
                        return false;
                    }
                })
                .forEach(function (cbox) {
                    cbox.hasMod('disabled', 'yes') ||
                        cbox.setMod('checked', 'yes')
                            .setMod('disabled', 'yes');
                });
        },

        /**
         * Отдает список чекбоксов
         * @return {Array}
         */
        _getDSPList: function () {
            return this._dspList ||
                (this._dspList = this.findBlocksInside('b-form-checkbox'));
        },

        /**
         * Обработчик события change поля direct_block
         *
         * @private
         */
        _checkLimits: function () {
            var val = this._direct.val();
            var states = this._states;

            Object.keys(states).forEach(function (key) {
                if (states[key].shown && key !== val) {
                    this._toggleField(key);
                }
            }, this);

            if (states.hasOwnProperty(val) && !states[val].shown) {
                this._toggleField(val);
            }
        },

        /**
         * Меняет состояние поля "Количество объявлений"
         * (прячет или показывает его)
         *
         * @private
         * @param {String} [val]
         */
        _toggleField: function (val) {
            var state = this._states[val];

            if (state.shown) {
                state.control.uncheckAll();
                state.control.hideError();
            }

            state.control.toggleMod('disabled', 'yes');
            state.src.toggleMod('disabled', 'yes');
            state.shown = !this._states[val].shown;
        }
    });
})(BEM);
