(function () {
    'use strict';

    var promises = BEM.blocks['i-promises'],
        ajax = promises.ajax;

    BEM.DOM.decl({block: 'b-news', modName: 'type', modVal: 'last'}, {

        onSetMod: {
            js: function () {
                this._load();
            }
        },

        _load: function () {
            if (this.params.url && this.params.url.length > 0)  {
                ajax.getJSON(this.params.url).then(this._renderNews.bind(this));
            }
        },

        _renderNews: function (data) {
            var news = BEMHTML.apply({
                block: 'b-news',
                elem: 'list',
                content: data
            });

            BEM.DOM.replace(this.elem('list'), news);
            this.dropElemCache('list');
        }

    });
})();
