(function() {
    function contains(str, pattern) {
        return str.indexOf(pattern) > -1;
    }

    function changeUrlParam(url, param, value) {
        var paramRe = new RegExp('(\\?|&)' + param + '=[^&]*');
        if (paramRe.test(url)) {
            return url.replace(paramRe, '$1' + param + '=' + encodeURIComponent(value));
        }

        return url + (contains(url, '?') ? '&' : '?') + param + '=' + value;
    }

    function getPageUrl(url, perpageCount, perpageParam, pageParam) {
        perpageParam = perpageParam || 'per_page';
        pageParam = pageParam || 'page';

        return changeUrlParam(
            changeUrlParam(url, perpageParam, perpageCount),
            pageParam,
            1
        );
    }

    var isFirstPerpageChange = true;
    var pageUrl;

    BEM.DOM.decl('b-pager', {
        onSetMod: {
            js: function () {
                this.__base.apply(this, arguments);
                pageUrl = this.params.pageUrl;
                this.findBlockInside('perpage-selector', 'b-form-select').on('change', this.onPerpageSelectChange);
            }
        },

        onPerpageSelectChange: function (e) {
            if (isFirstPerpageChange)
                isFirstPerpageChange = false;
            else
                window.location = getPageUrl(pageUrl, this.val());
        }
    });
})();
