BEM.DOM.decl('b-presentation', {
    onSetMod: {
        js: function() {
            var items = this.items = this.elem('nav-item');
            items.each(function() {
                var item = $(this);
                item.data('index', items.index(item));
            });
            this.curr = this.elem('nav-item', 'active', 'yes').data('index') || 0;
            this.slides = this.elem('slide-img');
            this.slideTexts = this.elem('slide-text');
            this.bindTo('btn-prev', 'click', this.onPrevClick);
            this.bindTo('btn-next', 'click', this.onNextClick);
            this.bindTo('nav-item', 'click', this.onNavItemClick);
        }
    },
    setItem: function(n) {
        var c = this.curr;
        this.delMod(this.items.eq(c), 'active');
        this.delMod(this.slides.eq(c), 'active');
        this.delMod(this.slideTexts.eq(c), 'active');

        this.setMod(this.items.eq(n), 'active', 'yes');
        this.setMod(this.slides.eq(n), 'active', 'yes');
        this.setMod(this.slideTexts.eq(n), 'active', 'yes');

        this.curr = n;
    },
    onPrevClick: function() {
        this.setItem(this.curr > 0 ? this.curr - 1 : this.items.length - 1);
    },
    onNextClick: function() {
        this.setItem(this.curr < this.items.length - 1 ? this.curr + 1 : 0);
    },
    onNavItemClick: function(e) {
        var i = $(e.target).data('index');
        if (i != this.curr) {
            this.setItem(i);
        }
    }
});
