(function () {
    'use strict';

    var bProgressPopup = null;

    BEM.DOM.decl('b-progress-popup', {
        onSetMod: {
            js: function () {
                this._initBlock();
            },

            progress: {
                on: function () {
                    this.show();
                },
                '': function () {
                    this.hide();
                }
            }
        },

        destruct: function () {
            this._bPopup.hide();
            if (this._bPopup) {
                this._bPopup.destruct.apply(this._bPopup, arguments);
            }
            this.__base.apply(this, arguments);
        },

        /**
         * @param {bemjson} content
         **/
        show: function (content) {
            var text = this.elem('text');
            if (content !== undefined && text.length) {
                BEM.DOM.update(this.elem('text'), BEMHTML.apply(content));
            }
            this._bSpin.setMod('progress', 'yes');
            this._bPopup.show(this.domElem);
        },

        hide: function () {
            this._bSpin.delMod('progress');
            this._bPopup.hide();
        },

        _initBlock: function () {
            // {b-spin}
            this._bSpin = this.findBlockOn('spin', 'b-spin');
            // {b-popupa}
            this._bPopup = this.findBlockInside('b-popupa');

            // to be able to use this block as singleton
            bProgressPopup = this;
        }
    }, {
        /**
         * Return the very last inited b-progress-popup on the page
         *
         * @return {b-progress-popup|null}
         **/
        getInstance: function () {
            return bProgressPopup;
        }
    });
})();
