/**
*
* @author Ilya Rezvov <irezvov@yandex-team.ru>
* @date 2012
* @description Block for switch http protocol.
*
*/

(function(window) {

    BEM.DOM.decl('b-proto-switcher', {
        onSetMod: {
            js: function() {
                this.init();
            }
        },

        init: function() {
            var c = this.findElem('proto', 'type', this.getCurrentProto());
            this.setMod(c, 'active', 'yes');

            this.bindTo('proto', 'click', this.onProtoClick);
        },

        onProtoClick: function(e) {
            var p = $(e.target).closest(this.buildSelector('proto')),
                proto = this.getMod(p, 'type');
            if ( proto != this.getCurrentProto() ) {
                this.switchTo(proto);
            }
        },

        getCurrentProto: function() {
            var p = window.location.protocol;
            return p.substr(0, p.length - 1);
        },

        switchTo: function(p) {
            var url = window.location.href.substring(window.location.protocol.length);
            window.location.href = p + ':' + url;
        }
    });
})(this);
