BEM.DOM.decl('b-search-popup', {

    onSetMod: {
        js: function() {
            this.tabs = this.findBlockOn('tabs', 'b-content-tabs');

            if ( this.tabs ) {
                this.tabs.on('change', this.onTabChange, this);
                this.onTabChange(null, this.tabs.val);
            }
        }
    },

    onAdvancedClick: function() {
        if ( this.hasMod('open', 'yes') ) {
            this.elem('under').slideToggle('swing', $.proxy(function() {
                this.toggleMod('open', 'yes', 'no');
                this.trigger('close');
            }, this));
        }
        else {
            this.elem('under').slideToggle('swing');
            this.toggleMod('open', 'yes', 'no');
            this.trigger('open');
        }
    },

    onTabChange: function(e, tabIndex) {
        this.currentTab = tabIndex;
        this.elem('content').hide().eq(tabIndex).show();;
    },

    getSearchType: function() {
        if ( this.hasMod('open', 'yes') ) {
            return 'simple';
            return ['simple', 'complex'][this.currentTab];
        }
        else {
            return 'string';
        }
    }
}, {
    live: function() {
        this.liveBindTo('advanced advanced-inner', 'click', function(e) {
            this.onAdvancedClick(e);
        });
    }
});
