/**
*
* @author Ilya Rezvov <irezvov@yandex-team.ru>
* @date 2012
* @description Module describes search block on top page.
*
*/

BEM.DOM.decl('b-search', {
    onSetMod: {
        js: function() {
            var searchButton = this.findBlockInside('button', 'b-form-button');

            //searchButton.on('click', this.onSearch, this);
            this.bindTo(this.domElem, 'submit', this.onSearch);
            this.searchPopup = this.findBlockInside('b-search-popup');
            this.simpleSearch = this.findBlockInside('b-simple-search');
            this.complexSearch = this.findBlockInside('b-filter');

            this.searchPopup.on('open', this.disableSearch, this);
            this.searchPopup.on('close', this.enableSearch, this);

            this.input = this.findBlockInside('input', 'b-form-input');
        }
    },

    disableSearch: function() {
        this.input.setMod('disabled', 'yes');
    },

    enableSearch: function() {
        this.input.delMod('disabled');
    },

    onSearch: function() {
        var st = this.searchPopup.getSearchType();
        if ( st == 'string' ) {
            this.elem('search-json').val('');
        }
        else {
            var s = this[ st + 'Search' ];
            if ( s && s.hasConfig() ) {
                this.elem('search-json').val(JSON.stringify(s.getConfig()));
            }
        }
    }
});
