BEM.DOM.decl( 'b-statistic-table', {
    onSetMod: {
        'js': function () {
            this.init();
        }
    },

    init: function () {
        var linkBlocks = this.findBlocksOn( 'head-link', 'b-link' ),
            table = this.findBlockInside( 'b-table' ),
            that = this;

        if ( linkBlocks != null ) {
            linkBlocks.forEach( function ( linkBlock ) {
                linkBlock.domElem.on( 'click', $.proxy(that.onHeadLinkClick, that));
            });
        }

        if ( table.getFloatHeader ) {
            table.getFloatHeader( function(elem) {
                elem.find( '.b-link' ).on( 'click', $.proxy(that.onHeadLinkClick, that));
            });
        }

        this.bindTo('show-more', 'click', this.onShowMoreClick);
    },

    onHeadLinkClick: function (e) {
        var colId = $(e.currentTarget).data('col-id');

        this.trigger( 'sort-column-click', colId );
        return false;
    },

    onShowMoreClick: function (e) {
        this.trigger( 'show-more-click' );
        return false;
    },

    hideMoreRow: function() {
        this.getMoreRow().hide();
    },

    getMoreRow: function() {
        return this.elem('more-row');
    },

    destruct: function () {
        var tableBlock = this.findBlockInside( 'b-table' );

        if ( tableBlock != null ) {
            tableBlock.destruct();
        }
    },

    refreshFloatHeader: function () {
        var table = this.findBlockInside( 'b-table' );
        table.updateFake();
    }
});
