(function (BEM) {
    'use strict';

    var DISPOSITION_TOP = '0';
    var INTERACTION_OVERLAY = '0';

    function preventFirstCall(fn, ctx) {
        var prevent = true;
        return function () {
            if (prevent) {
                prevent = false;
                return;
            }
            fn.apply(ctx, arguments);
        };
    }

    BEM.DOM.decl('b-stripe-appearance', {
        onSetMod: {
            js: function () {
                this._selects = this.findBlocksInside('b-form-select');
                this._initControls();
                this._initErrors();
            }
        },

        _initControls: function () {
            var _this = this;
            this._selects.forEach(function (select) {
                select.on('change', preventFirstCall(_this._onSelectChanged, _this));
            });

            this._updateControlsVisibility();
        },

        _getSelectName: function (select) {
            var prefix = this.params.prefix || '';
            return select.elem('select').attr('name').replace(prefix, '');
        },

        _initErrors: function () {
            var _this = this;
            var errors = this.params.errors;
            if (!errors) {
                return;
            }

            var fields = this.elem('field').toArray();
            fields.forEach(function (field) {
                var select = _this.findBlockInside($(field), 'b-form-select');
                var name = _this._getSelectName(select);

                if (errors[name] && _this.hasMod($(field), 'visible', 'yes')) {
                    select.showError(errors[name]);
                }
            });
        },

        _hideErrors: function () {
            this.findBlocksInside('b-form-select').forEach(function (select) {
                select.hideError();
            });
        },

        _updateControlsVisibility: function () {
            var _this = this;
            var visibility = this._getControlsVisibility();

            this.elem('field').toArray().forEach(function (field) {
                var select = _this.findBlockInside($(field), 'b-form-select');
                var name = _this._getSelectName(select);

                _this.setMod($(field), 'visible', visibility[name] === true ? 'yes' : '');
            });
        },

        _getControlsVisibility: function () {
            var _this = this;
            var visibility = {disposition_id: true};

            var values = this._selects.reduce(function (result, select) {
                var name = _this._getSelectName(select);
                result[name] = select.val();
                return result;
            }, {});

            if (values.disposition_id === DISPOSITION_TOP) {
                visibility.interaction_id = true;
            }

            if (values.disposition_id === DISPOSITION_TOP && values.interaction_id === INTERACTION_OVERLAY) {
                visibility.type_id = true;
                visibility.animation = true;
            }

            return visibility;
        },

        _onSelectChanged: function () {
            this._updateControlsVisibility();
            this._hideErrors();
        }
    });
})(BEM);
