(function (BEM) {
    'use strict';

    BEM.DOM.decl({name: 'b-switch-list', modName: 'type', modVal: 'common'}, {
        serialize: function () {
            var name = this.params.name;
            var switches = this.findBlocksInside('item', 'b-form-switch');
            var choosen =
                switches.filter(function (sw) {
                        return sw.position() === 'left';
                    }).map(function (sw) {
                        return sw.elem('input').eq(0).attr('name').replace(name + '-', '');
                    });
            var id = name.replace(/\D/g, '');
            return {
                id: id,
                list: JSON.stringify(choosen)
            };
        },

        onSuccess: function () {
            if (this.params.popup) {
                var popup = this.params.popup === true ? 'b-popupa' : this.params.popup;
                this.findBlockOutside(popup).hide();
            }
        }
    }, {});

})(BEM);
