(function (BEM) {
    'use strict';

    BEM.DOM.decl({name: 'b-table-cell-text', modName: 'edit', modVal: 'dsp'}, {
        onSetMod: {
            js: function () {
                this.__base.apply(this, arguments);
                this.refreshText();
            }
        },
        refreshText: function () {
            var text;
            var titles = this.params.titles;
            var blocks = this.params.editBlockParams;
            if (Array.isArray(blocks)) {
                text = blocks.reduce(function (result, block, index) {
                    result += (titles[index] + ': ' + $.trim(block.value));
                    if (index !== blocks.length - 1) {
                        result += '; ';
                    }
                    return result;
                }, '');
            }

            this.elem('text').text(text);
        }
    }, {});

})(BEM);
