(function () {
    'use strict';

    /**
     * Блоки, которые нужно скрыть при определенных условиях
     **/
    var FIELDS_TO_HIDE = {
        'dsp-list': { // знчение мода b-table-field_name_
            name: 'settings_dsp_on_blocks', // от какой настройки зависит
            value: '1' // в каком значении должна быть настройка, чтобы блок было скрыто
        }
    };

    BEM.DOM.decl('b-table-row', {
        onSetMod: {
            js: function () {
                this._initBlock();

                if (this._bTableCellTextList !== undefined &&
                    this._bTableCellTextList !== null &&
                    this._bTableCellTextList.length !== 0) {

                    this._addListeners();
                }
            }
        },

        _initBlock: function () {
            // {array:b-table-cell-text}
            this._bTableCellTextList = this.findBlocksInside('b-table-cell-text');
            // {array:b-table-field}
            this._bTableFieldList = this.findBlocksInside('b-table-field');
            // {number}
            this._editCounter = 0;
        },

        _addListeners: function () {
            var _this = this;

            function addChangeListener(block) {
                block.on('change', _this._onTableCellTextChange, _this);
                block.on('edit-start', _this._onTableCellTextEditStart, _this);
                block.on('edit-stop', _this._onTableCellTextEditStop, _this);
            }

            // если this передать тут, то получится 'Possible strict violation'
            this._bTableCellTextList.forEach(addChangeListener);
        },

        /**
         * @param {bem-event} e
         * @param {object} data
         * @param {object} data.data Данные, для блоков, в которых нужно поменять значение
         * @param {object} data.block Параметры блока, на котором произошло событие
         * @param {string} data.block.name
         * @param {string} data.block.value
         **/
        _onTableCellTextChange: function (e, data) {
            var cells = this._bTableCellTextList;

            Object.keys(data.data || {}).forEach(function (key) {
                cells.forEach(function (cell) {
                    if (cell.getName() === key) {
                        cell.setValue(data[key]);
                    }
                });
            });

            // скрываем/показываем блоки, которые зависят от измененного значения
            // не учитываются значения, переданные через data.data
            // (они как правило приходят с сервера)
            this._bTableFieldList.forEach(function (block) {
                var blockName = block.getMod('name');
                var params = FIELDS_TO_HIDE[blockName];
                if (typeof params !== 'undefined' && params.name === data.block.name) {
                    if (params.value === data.block.value) {
                        block.setMod('display', 'none');
                    } else {
                        block.delMod('display');
                    }
                }
            });

            this.trigger('change');
        },

        _onTableCellTextEditStart: function (e, data) {
            if (data && data.initialEvent) {
                // in case we have table with table in popup
                if (!this.containsDomElem($(data.initialEvent.target))) {
                    return;
                }
            }
            this.setMod('mode', 'edit');
            this._editCounter = this._editCounter + 1;
        },

        _onTableCellTextEditStop: function () {
            this._editCounter = this._editCounter - 1;
            if (this._editCounter === 0) {
                this.delMod('mode');
            }
        }
    }, {
        live: function () {
            this.liveInitOnEvent('mouseenter mouseover');
        }
    });
})();
