(function (BEM, window) {
    'use strict';

    var _ = require('lodash');

    BEM.DOM.decl({block: 'b-table', modName: 'header', modVal: 'float'}, {
        onSetMod: {
            js: function() {
                this.bindToDoc('scroll', this._onScroll);
                this.bindToDomElem($(window), 'resize', _.throttle(this._onResize, 50));
                this.header = this.elem('header').eq(0);
                this.windowScrollLeft = $(window).scrollLeft();

                var that = this;
                setTimeout(function() {
                    that._onScroll();
                }, 1);
            }
        },
        _onScroll: function() {
            var vdiff = this.header.offset().top - $(window).scrollTop(),
                hdiff = $(window).scrollLeft() - this.windowScrollLeft;
            if (vdiff < 0 && Math.abs(vdiff) < this.domElem.height()) {
                this.showFake();
            } else {
                this.hideFake();
            }
            if ( hdiff !== 0) {
                this.windowScrollLeft += hdiff;
                if ( this.getFake().visible ) {
                    this.fake.css('left', this.header.offset().left - this.windowScrollLeft);
                }
            }
        },
        _onResize: function() {
            this._onScroll();
            if ( this.fake ) {
                if (this.fake.visible) {
                    this.updateFake();
                } else {
                    this.fake.updateOnShow = true;
                }
            }
        },
        showFake: function() {
            var fake = this.getFake();
            if ( !fake.visible ) {
                if ( this.fake.updateOnShow ) {
                    this.updateFake();
                    this.fake.updateOnShow = false;
                }
                fake.show();
                fake.visible = true;
            }
        },
        hideFake: function() {
            var fake = this.getFake();
            if ( fake.visible ) {
                fake.hide();
                fake.visible = false;
            }
        },
        getFake: function() {
            if (!this.fake) {
                this.fake = $('<table class="' + this.domElem.attr('class') + ' b-table b-table__fake"></table>')
                    .appendTo('body')
                    .append(this.header.clone());
                // ugly hack to init b-help-box due html copied from inited DOM
                this.fake.find('.b-help-box').removeClass('b-help-box_js_inited');
                this.fake.find('.b-popupa').removeClass('b-popupa_js_inited');
                BEM.DOM.init(this.fake);
                this.updateFake();
                this.trigger('floatheaderappear', this.fake);
            }
            return this.fake;
        },
        updateFake: function() {
            var offset = this.header.offset();
            this.fake.css('left', offset.left - this.windowScrollLeft);
            this.fake.width(this.header.width());
            var fakeThs = $('th', this.fake),
                trueThs = $('th', this.header);
            fakeThs.each(function(i) {
                $(this).width($(trueThs[i]).width());
            });
        },

        getFloatHeader: function (callback) {
            if (this.fake != null) {
                callback(this.fake);
            } else {
                this.on('floatheaderappear', function () {
                    callback(this.fake);
                });
            }
        },

        destruct: function () {
            this.findBlocksInside(this.fake, 'b-help-box')
                .concat(this.findBlocksInside('b-help-box'))
                .forEach(function(block){
                    block.destruct();
                });
            this.fake.remove();
        }
    });
})(BEM, window);
