(function (BEM) {
    'use strict';

    BEM.DOM.decl({name: 'b-table', modName: 'row-limit', modVal: 'yes'}, {
        onSetMod: {
            js: function () {
                this.moreButton = this.findBlockInside('more-button', 'b-form-button');
                this.params.rowStep  = this.params.rowStep || 10;
                this.renderMoreRows();

                this.moreButton.on('click', this.onMoreButtonClick, this);

                return this.__base.apply(this, arguments);
            }
        },

        renderMoreRows: function () {
            var rowsToShow = this.params.rows.splice(0, this.params.rowStep);

            if (this.params.rows.length > 0) {
                this.elem('more-button-row').show();
            } else {
                this.elem('more-button-row').hide();
            }

            var html = BEMHTML.apply({
                block: 'b-table',
                content: rowsToShow
            });

            var $rows = $(html).find(this.buildSelector('row'));
            if (this.elem('more-button-row').length > 0) {
                $rows.insertBefore(this.elem('more-button-row'));
            } else {
                $rows.appendTo(this.domElem);
            }
        },

        onMoreButtonClick: function () {
            this.renderMoreRows();
        }

    }, {
        //static methods
    });

})(BEM);
