(function () {
    'use strict';

    BEM.DOM.decl('b-task-status', {
        onSetMod: {
            js: function () {
                // Инициализируем кнопку, если есть (может появиться из tt2)
                this._initButton();
            }
        },

        _initButton: function () {
            var button = this._getContinueButton();

            if (button) {
                button.on('click', this._triggerContinue.bind(button, this));
            }
        },

        _getContinueButton: function () {
            return this.findBlockInside('b-form-button');
        },

        // Хэшик с урлом и айдишником для AJAX запроса
        _getContinueData: function () {
            return {
                url: this.params.updateButton.url,
                id: this.id()
            };
        },

        _triggerContinue: function (parent) {
            // Если кнопка не активна, то событие не происходит
            if (this.hasMod('disabled', 'yes')) {
                return false;
            }

            this.setMod('disabled', 'yes');
            parent.trigger('continue', parent._getContinueData());
        },

        /**
         * Отдает id, публичный метод
         */
        id: function () {
            return this.params.id;
        },

        /**
         * Флаг, который показывает, есть ли прогрессбар или нет
         * публичный метод
         */
        isRunning: function () {
            return this.params.isRunning;
        },

        _setRunningState: function (flag) {
            this.params.isRunning = Boolean(flag);
        },

        /**
         * Показывает прогрессбар в содержимом блока (если его нет)
         * и обновляет проценты и время прогресса
         * публичный метод
         */
        showBar: function (progress, time) {
            var bar;

            if (this.isRunning()) {
                bar = this.findBlockInside('b-progressbar');

                if (bar) {
                    bar.setProgress(progress);
                    bar.setEstimated(time);
                }
            } else {
                // Добавляем прогресс бар
                bar = {
                    block: 'b-progressbar',
                    progress: progress,
                    estimated: time,
                    js: {id: this.params.id}
                };

                BEM.DOM.update(this.domElem, BEMHTML.apply(bar));
                this._setRunningState(true);
            }
        },

        /**
         * Рисует сообщение с кнопкой для перезабора статистики
         * публичный метод
         */
        showError: function (msg) {
            var button = {
                    block: 'b-form-button',
                    mods: {size: 's', theme: 'grey-s'},
                    content: this.params.updateButton.label
                };

            this._setRunningState(false);
            BEM.DOM.update(this.domElem, msg + ' ' + BEMHTML.apply(button));
            this._initButton();
        },

        /**
         * Рисует сообщение
         */
        showText: function (msg) {
            this._setRunningState(false);
            BEM.DOM.update(this.domElem, msg);
        }
    });
})();
