/*global _*/
(function(_) {
    'use strict';

    var isEmpty = _.isEmpty;
    var keys = _.keys;

    BEM.DOM.decl('b-web-stat-updater', {
        onSetMod: {
            js: function () {
                var _this = this;

                // Периодичность опроса сервера (мс)
                this._interval = this.params.interval || 5000;

                // Список айдишников, статусы которых обновляются
                this.ids = {};
                // Айди таймера (если есть)
                this.timerId = null;

                // Получаем список блоков, отображающих статус
                this._retrieveBlockList();

                // Поиск прогрессбаров и инициализация опроса
                this._sBlocks.forEach(function (b) {
                    var id = b.id();

                    if (b.isRunning()) {
                        _this._add(id, b);
                    }
                });
            }
        },

        _retrieveBlockList: function () {
            var _this = this;

            if (this._sBlocks) {
                this._sBlocks.forEach(function (b) {
                    b.un('continue');
                });
            }

            this._sBlocks = this.findBlocksInside('b-task-status');
            this._sBlocks.forEach(function (b) {
                b.on('continue', function (e, data) {
                    var b = e.block,
                        url = data.url,
                        id = data.id;

                    _this._query(url, 'id=' + id, function (obj) {
                        _this._add(id, b);
                        _this._processData(obj);
                    }, function () {
                        if (!_this.timerId) {
                            _this.timerId = setTimeout(_this._flush.bind(_this), _this._interval);
                        }
                    });
                });
            });
        },

        _processData: function (obj) {
            var block = this.ids[obj.id];

            if (obj.can_be_run) {
                block.showBar(obj.completed_percent, obj.remaining_time);
            } else {
                if (obj.error_description) {
                    block.showError(obj.multistate_name + ' ' + obj.error_description);
                } else {
                    block.showText(obj.multistate_name);
                }

                // Удаляем айдишник, т.к. уже прогрессбар отработал и в новых запросах не понадобится
                delete this.ids[obj.id];
            }
        },

        _add: function (id, block) {
            this.ids[id] = block;

            if (!this.timerId) {
                this.timerId = setTimeout(this._flush.bind(this), this._interval);
            }
        },

        _flush: function () {
            var _this = this;
            var url = this.params.url;
            var data = keys(this.ids).map(function (el) { return 'id=' + el; }).join('&');

            this._query(url, data, function (arr) {
                arr.forEach(_this._processData.bind(_this));
            }, function () {
                if (isEmpty(_this.ids)) {
                    _this.timerId = null;
                } else {
                    _this.timerId = setTimeout(_this._flush.bind(_this), _this._interval);
                }
            });
        },

        _query: function (url, data, success, result) {
            $.ajax({
                type: 'post',
                url: url,
                dataType: 'json',
                data: data
            }).success(success).done(result);
        }
    });
})(_);
