BEM.DOM.decl('b-widget-library', {
    onSetMod: {
        js: function() {
            this._initBlock();
            this._addListeners();
            this._loadLibrary();
            this.setMod('visibility', 'hidden');
        }
    },

    _initBlock: function() {
        this._widgetList = null;
        // {b-popupa}
        this._bPopup = this.findBlockInside('b-popupa');
        // {b-form-button}
        this._bFormButton = this.findBlockInside('b-form-button');
    },

    _addListeners: function() {
        this._bFormButton.on('click', $.proxy(this._onTriggerClick, this));
    },

    _onTriggerClick: function() {
        this._show();
    },

    _loadLibrary: function() {
        $.ajax({
            type: 'GET',
            cache: false,
            url: '/dashboard/library',
            dataType: 'json',
            success: $.proxy(this._onLibraryLoad, this)
        });
    },

    /**
     * @param {array:object} library
     **/
    _onLibraryLoad: function(library) {
        this._widgetList = library.filter(function (widget) {
            return widget.type.indexOf('revenue') !== 0 && widget.type.indexOf('statistics') !== 0;
        });

        if (this._widgetList && this._widgetList.length > 0) {
            this._bPopup.setContent(BEMHTML.apply({
                block: 'b-widget-library',
                elem: 'content',
                widgetList: this._widgetList
            }));

            this._addContentListeners();
            this.setMod('visibility', 'visible');
        }
    },

    _addContentListeners: function() {
        this._bPopup.domElem.find(this.buildSelector('item')).on('click', $.proxy(this._onItemClick, this));
    },

    _show: function() {
        this._bPopup.show(this._bFormButton.domElem);
    },

    _onItemClick: function(e) {
        var type = $(e.currentTarget).attr('data-type');
        e.preventDefault();

        this._bPopup.hide();
        this.trigger('select', type);
    }
});
