(function () {
    'use strict';
    BEM.DOM.decl('b-widget-setup', {
        onSetMod: {
            js: function () {
                this._initBlock();
            }
        },

        show: function (opts) {
            if (opts) {
                this._opts = opts;
            }
            this._show();
        },

        destruct: function () {
            if (this._piPopup && this._piPopup.destruct !== undefined) {
                this._piPopup.destruct();
            }
            this.__base.apply(this, arguments);
        },

        _initBlock: function () {
            this._$popupContent = this.elem('popup-content');
            // {pi-popup}
            this._piPopup = this.findBlockInside('pi-popup');
            // {b-widget-setup__$submit}
            this.$submit = null;
            // {object}
            this._opts = null;

            this._piPopup.on('hide', this._onPopupHide, this);
        },

        /**
         * What to show depending on type
         **/
        _show: function () {
            // if there is nothing to do just apply it
            this.trigger('apply', this._opts);
        },

        /**
         * Render and show popup,
         * executed in _show of the specific type
         **/
        _showPopup: function () {
            this._renderPopup(this._opts);
            this._piPopup.show();
            BEM.DOM.init(this._piPopup.domElem);
            this._addPopupListeners();
        },

        _hidePopup: function () {
            if (this._piPopup) {
                this._piPopup.hide();
            }
        },

        _onPopupHide: function () {
            this._removePopupListeners();
            this._hideDatepicker();
        },

        _hideDatepicker: function () {
            var blockList = this.findBlocksInside('b-form-datepicker');
            if (blockList) {
                blockList.forEach(function (block) {
                    if (block && block.popup) {
                        block.popup.hide();
                    }
                });
            }
        },

        /**
         * Render popup content depends on opts
         **/
        _renderPopup: function () {
            this._$popupContent.html(BEMHTML.apply({
                block: 'b-widget-setup',
                elem: 'layout',
                type: this._getType(),
                opts: this._opts
            }));
        },

        _getType: function () {
            return this._opts.widget.mods.type;
        },

        _addPopupListeners: function () {
            this.$submit = this._piPopup.domElem.find(this.buildSelector('submit'));
            this.$submit.on('click', $.proxy(this._onSubmitClick, this));
        },

        _removePopupListeners: function () {
            this.$submit.off('click');
            this.$submit = null;
        },

        /**
         * Get changed values,
         * trigger apply event on block
         **/
        _onSubmitClick: function () {
            if (this._refreshOpts()) {
                this._hidePopup();
                this.trigger('apply', this._opts);
            }
        },

        /**
         * @return {boolean} - true if fields values are valid
         **/
        _refreshOpts: function () {
            var fieldsValues = this._getFieldsValues();

            if (!this._opts.widget.js) {
                this._opts.widget.js = {};
            }

            this._opts.widget.mods.width = fieldsValues.width;
            this._opts.widget.title = fieldsValues.title;
            return true;
        },

        /**
         * Return values from fields
         *
         * return {string:string}
         **/
        _getFieldsValues: function () {
            var $commonFields = this._piPopup.domElem.find(this.buildSelector('common-fields')),
                values = {};

            this.findBlocksInside($commonFields, 'b-form-input').forEach(function (bFormInput) {
                values[bFormInput.name()] = bFormInput.val();
            });

            this.findBlocksInside($commonFields, 'b-form-radio').forEach(function (bFormRadio) {
                values[bFormRadio.elem('radio').attr('name')] = bFormRadio.val();
            });
            return values;
        }
    });
})();
