(function (BEM) {

    'use strict';

    var ajax = BEM.blocks['i-promises'].ajax;

    BEM.DOM.decl({name: 'b-widget', modName: 'type', modVal: 'dsp-errors'}, {
        onSetMod: {
            js: function () {
                this.url = '/dsp/get_data_for_dsp_errors_widget';

                this.__base();
                this._load();
            }
        },

        _load: function () {
            this.setMod('state', 'loading');

            var periods = [
                {period__name: 'thismonth'},
                {period__name: 'lastmonth'}
            ];

            var data = {
                periods: JSON.stringify(periods),
                sign: this.params.sign,
                ajax: 1
            };

            ajax.post(this.url, data)
                .then(this.updateRespone, this)
                .then(this.updateError, this)
                .always(this._onRequestRecived, this);
        },

        updateRespone: function (data) {
            var responses = data.data;
            if (!responses ||
                !responses[0] || responses[0].status !== 'ok' ||
                !responses[1] || responses[1].status !== 'ok') {
                return {error: true};
            }
            this.currentPeriodCount = responses[0].data;
            this.previousPeriodCount = responses[1].data;

            BEM.DOM.append(this.elem('count', 'period', 'current'), BEMHTML.apply({
                block: 'b-formatter',
                mods: {type: 'number'},
                value: this.currentPeriodCount
            }));

            BEM.DOM.append(this.elem('count', 'period', 'previous'), BEMHTML.apply({
                block: 'b-formatter',
                mods: {type: 'number'},
                value: this.previousPeriodCount
            }));

            this.setMod(this.elem('arrow'), 'direction',
                Number(this.currentPeriodCount) < Number(this.previousPeriodCount) ? 'down' : 'up');
        },

        updateError: function (response) {
            if (response.error) {
                BEM.DOM.update(this.elem('container'), BEMHTML.apply({
                    block: 'b-widget',
                    elem: 'error',
                    content: BEM.I18N('b-widget', 'Server error')
                }));
            }
        },

        _onRequestRecived: function () {
            this.delMod('state');
        }

    }, {});

})(BEM);
